/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.CraftingSettingsContainerMenu;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewRequestMessage;
import com.refinedmods.refinedstorage.screen.AmountSpecifyingScreen;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.FluidGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class CraftingSettingsScreen
extends AmountSpecifyingScreen<CraftingSettingsContainerMenu> {
    private final IGridStack stack;

    public CraftingSettingsScreen(BaseScreen parent, Player player, IGridStack stack) {
        super(parent, new CraftingSettingsContainerMenu(player, stack), 172, 99, player.m_150109_(), (Component)Component.m_237115_((String)"container.crafting"));
        this.stack = stack;
    }

    @Override
    protected Component getOkButtonText() {
        return Component.m_237115_((String)"misc.refinedstorage.start");
    }

    @Override
    protected int[] getIncrements() {
        if (this.stack instanceof FluidGridStack) {
            return new int[]{100, 500, 1000, -100, -500, -1000};
        }
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack instanceof FluidGridStack ? 1000 : 1;
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int quantity = Integer.parseInt(this.amountField.m_94155_());
            RS.NETWORK_HANDLER.sendToServer(new GridCraftingPreviewRequestMessage(this.stack.getId(), quantity, shiftDown, this.stack instanceof FluidGridStack));
            this.okButton.f_93623_ = false;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

