/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.data;

import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.blockentity.ClientNode;
import com.refinedmods.refinedstorage.util.AccessTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public final class RSSerializers {
    public static final EntityDataSerializer<List<ClientNode>> CLIENT_NODE_SERIALIZER = new EntityDataSerializer<List<ClientNode>>(){

        public void write(FriendlyByteBuf buf, List<ClientNode> nodes) {
            buf.writeInt(nodes.size());
            for (ClientNode node : nodes) {
                buf.m_130055_(node.getStack());
                buf.writeInt(node.getAmount());
                buf.writeInt(node.getEnergyUsage());
            }
        }

        public List<ClientNode> read(FriendlyByteBuf buf) {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                nodes.add(new ClientNode(buf.m_130267_(), buf.readInt(), buf.readInt()));
            }
            return nodes;
        }

        public EntityDataAccessor<List<ClientNode>> m_135021_(int id) {
            return null;
        }

        public List<ClientNode> copy(List<ClientNode> value) {
            return value;
        }
    };
    public static final EntityDataSerializer<FluidStack> FLUID_STACK_SERIALIZER = new EntityDataSerializer<FluidStack>(){

        public void write(FriendlyByteBuf buf, FluidStack value) {
            value.writeToPacket(buf);
        }

        public FluidStack read(FriendlyByteBuf buf) {
            return FluidStack.readFromPacket((FriendlyByteBuf)buf);
        }

        public EntityDataAccessor<FluidStack> m_135021_(int id) {
            return null;
        }

        public FluidStack copy(FluidStack value) {
            return value;
        }
    };
    public static final EntityDataSerializer<AccessType> ACCESS_TYPE_SERIALIZER = new EntityDataSerializer<AccessType>(){

        public void write(FriendlyByteBuf buf, AccessType value) {
            buf.writeInt(value.getId());
        }

        public AccessType read(FriendlyByteBuf buf) {
            return AccessTypeUtils.getAccessType(buf.readInt());
        }

        public EntityDataAccessor<AccessType> m_135021_(int id) {
            return null;
        }

        public AccessType copy(AccessType value) {
            return value;
        }
    };
    public static final EntityDataSerializer<Long> LONG_SERIALIZER = new EntityDataSerializer<Long>(){

        public void write(FriendlyByteBuf buf, Long value) {
            buf.writeLong(value.longValue());
        }

        public Long read(FriendlyByteBuf buf) {
            return buf.readLong();
        }

        public EntityDataAccessor<Long> m_135021_(int id) {
            return null;
        }

        public Long copy(Long value) {
            return value;
        }
    };
    public static final EntityDataSerializer<Optional<ResourceLocation>> OPTIONAL_RESOURCE_LOCATION_SERIALIZER = new EntityDataSerializer<Optional<ResourceLocation>>(){

        public void write(FriendlyByteBuf buf, Optional<ResourceLocation> value) {
            buf.writeBoolean(value.isPresent());
            value.ifPresent(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        }

        public Optional<ResourceLocation> read(FriendlyByteBuf buf) {
            if (!buf.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(buf.m_130281_());
        }

        public EntityDataAccessor<Optional<ResourceLocation>> m_135021_(int id) {
            return null;
        }

        public Optional<ResourceLocation> copy(Optional<ResourceLocation> value) {
            return value;
        }
    };
    public static final EntityDataSerializer<List<Set<ResourceLocation>>> LIST_OF_SET_SERIALIZER = new EntityDataSerializer<List<Set<ResourceLocation>>>(){

        public void write(FriendlyByteBuf buf, List<Set<ResourceLocation>> value) {
            buf.writeInt(value.size());
            for (Set<ResourceLocation> values : value) {
                buf.writeInt(values.size());
                values.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
            }
        }

        public List<Set<ResourceLocation>> read(FriendlyByteBuf buf) {
            ArrayList<Set<ResourceLocation>> value = new ArrayList<Set<ResourceLocation>>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                int setSize = buf.readInt();
                HashSet<ResourceLocation> values = new HashSet<ResourceLocation>();
                for (int j = 0; j < setSize; ++j) {
                    values.add(buf.m_130281_());
                }
                value.add(values);
            }
            return value;
        }

        public EntityDataAccessor<List<Set<ResourceLocation>>> m_135021_(int id) {
            return null;
        }

        public List<Set<ResourceLocation>> copy(List<Set<ResourceLocation>> value) {
            return value;
        }
    };

    private RSSerializers() {
    }
}

