/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.data;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationWatcher;
import com.refinedmods.refinedstorage.network.sync.BlockEntitySynchronizationParamaterUpdateMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntitySynchronizationManager {
    private static final Map<ResourceLocation, BlockEntitySynchronizationParameter> REGISTRY = new HashMap<ResourceLocation, BlockEntitySynchronizationParameter>();
    private final BlockEntity blockEntity;
    private final List<BlockEntitySynchronizationParameter> parameters;
    private final List<BlockEntitySynchronizationParameter> watchedParameters;
    private final List<BlockEntitySynchronizationWatcher> watchers = new CopyOnWriteArrayList<BlockEntitySynchronizationWatcher>();

    public BlockEntitySynchronizationManager(BlockEntity blockEntity, BlockEntitySynchronizationSpec spec) {
        this.blockEntity = blockEntity;
        this.parameters = spec.getParameters();
        this.watchedParameters = spec.getWatchedParameters();
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public List<BlockEntitySynchronizationParameter> getParameters() {
        return this.parameters;
    }

    public List<BlockEntitySynchronizationParameter> getWatchedParameters() {
        return this.watchedParameters;
    }

    public void addWatcher(BlockEntitySynchronizationWatcher listener) {
        this.watchers.add(listener);
    }

    public void removeWatcher(BlockEntitySynchronizationWatcher listener) {
        this.watchers.remove(listener);
    }

    public void sendParameterToWatchers(BlockEntitySynchronizationParameter parameter) {
        this.watchers.forEach(l -> l.sendParameter(false, parameter));
    }

    public static synchronized void registerParameter(BlockEntitySynchronizationParameter parameter) {
        REGISTRY.put(parameter.getId(), parameter);
    }

    public static BlockEntitySynchronizationParameter getParameter(ResourceLocation id) {
        return REGISTRY.get(id);
    }

    public static void setParameter(BlockEntitySynchronizationParameter parameter, Object value) {
        RS.NETWORK_HANDLER.sendToServer(new BlockEntitySynchronizationParamaterUpdateMessage(parameter, value));
    }
}

