/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.network.NetworkHandler;
import it.hurts.octostudios.rarcompat.network.packets.SteadfastSpikesPacket;
import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SteadfastSpikesItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"resistance").stat(StatData.builder((String)"modifier").initialValue(0.2, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-11260640).borderBottom(-11183260).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        if (!(entity instanceof Player) || !(player = (Player)entity).m_20193_().m_5776_() || !this.canUseAbility(stack, "passive") || player.m_20096_() || !player.f_19862_ || player.m_20184_().f_82480_ >= -0.1) {
            return;
        }
        NetworkHandler.sendToServer(new SteadfastSpikesPacket());
        player.m_20334_(player.m_20184_().f_82479_, -0.05, player.m_20184_().f_82481_);
        player.m_20193_().m_7106_(ParticleUtils.constructSimpleSpark((Color)new Color(50, 20 + player.m_217043_().m_188503_(50), 0), (float)0.5f, (int)50, (float)0.9f), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
    }

    @Mod.EventBusSubscriber
    public static class SteadfastSpikesEvent {
        @SubscribeEvent
        public static void onLivingKnockBack(LivingKnockBackEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.STEADFAST_SPIKES.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof SteadfastSpikesItem)) {
                return;
            }
            SteadfastSpikesItem relic = (SteadfastSpikesItem)item;
            event.setStrength((float)((double)event.getStrength() * (1.0 - relic.getAbilityValue(stack, "resistance", "modifier"))));
            relic.spreadExperience((LivingEntity)player, stack, 1);
        }

        @SubscribeEvent
        public static void onLivingSlipping(LivingSlippingEvent event) {
            Player player;
            LivingEntity livingEntity;
            if (event.getFriction() <= 0.6f || !((livingEntity = event.getEntity()) instanceof Player) || (player = (Player)livingEntity).m_20069_() || player.m_20077_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.STEADFAST_SPIKES.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof SteadfastSpikesItem)) {
                return;
            }
            SteadfastSpikesItem relic = (SteadfastSpikesItem)item;
            if (player.f_19797_ % 60 == 0 && player.m_20096_() && (player.m_20184_().f_82479_ != 0.0 || player.m_20184_().f_82481_ != 0.0)) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
            event.setFriction((float)((double)event.getFriction() * (1.0 - relic.getAbilityValue(stack, "resistance", "modifier") / 3.0)));
        }
    }
}

