/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.bracelet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class OnionRingItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"onion").stat(StatData.builder((String)"amount").initialValue(0.01, 0.015).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).ability(AbilityData.builder((String)"saturation").requiredLevel(5).stat(StatData.builder((String)"chance").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-1014486).borderBottom(-7126255).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    @Mod.EventBusSubscriber
    public static class OnionRingEvent {
        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            OnionRingItem relic;
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ONION_RING.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof OnionRingItem) || !(relic = (OnionRingItem)item).canUseAbility(stack, "onion")) {
                return;
            }
            int currentHunger = player.m_36324_().m_38702_();
            double modifier = relic.getAbilityValue(stack, "onion", "amount");
            event.setNewSpeed((float)((double)event.getNewSpeed() + (double)event.getNewSpeed() * ((double)currentHunger * modifier)));
        }

        @SubscribeEvent
        public static void onBlockDestroy(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ONION_RING.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof OnionRingItem)) {
                return;
            }
            OnionRingItem relic = (OnionRingItem)item;
            RandomSource random = player.m_217043_();
            if (relic.canUseAbility(stack, "onion") && (double)event.getState().m_60800_((BlockGetter)player.m_9236_(), player.m_20183_()) >= 0.5 && (double)player.m_36324_().m_38702_() / 20.0 >= random.m_188500_()) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
            FoodData footData = player.m_36324_();
            if (relic.canUseAbility(stack, "saturation") && random.m_188500_() <= relic.getAbilityValue(stack, "saturation", "chance") && footData.m_38721_()) {
                footData.m_38707_(1, 0.5f);
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

