/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge.inventory.item;

import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCapProvider
implements ICapabilityProvider {
    private final Function<Direction, Container> inventoryBlock;

    public ItemCapProvider(Function<Direction, Container> inventoryBlock) {
        this.inventoryBlock = inventoryBlock;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (this.inventoryBlock.apply(arg) == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> {
                InvWrapper invWrapper;
                Container container = this.inventoryBlock.apply(arg);
                if (container instanceof WorldlyContainer) {
                    WorldlyContainer sided = (WorldlyContainer)container;
                    invWrapper = new SidedInvWrapper(sided, arg);
                } else {
                    invWrapper = new InvWrapper(container);
                }
                return invWrapper;
            }).cast();
        }
        return LazyOptional.empty();
    }
}

