/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.advancement;

import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.advancement.OECriteriaTriggers;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModInvolvementTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("otyacraftengine", "mod_involvement");

    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, @NotNull DeserializationContext deserializationContext) {
        String mid = jsonObject.has("modid") ? jsonObject.get("modid").getAsString() : "";
        return new TriggerInstance(contextAwarePredicate, mid);
    }

    public static void trigger(ServerPlayer serverPlayer, ItemStack itemStack) {
        OECriteriaTriggers.MOD_INVOLVEMENT_TRIGGER.trigger_(serverPlayer, itemStack);
    }

    public static void trigger(ServerPlayer serverPlayer, String modId) {
        OECriteriaTriggers.MOD_INVOLVEMENT_TRIGGER.trigger_(serverPlayer, modId);
    }

    private void trigger_(ServerPlayer serverPlayer, ItemStack itemStack) {
        this.m_66234_(serverPlayer, triggerInstance -> triggerInstance.matches(itemStack));
    }

    private void trigger_(ServerPlayer serverPlayer, String modId) {
        this.m_66234_(serverPlayer, triggerInstance -> triggerInstance.matches(modId));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @NotNull
        private final String modId;

        public TriggerInstance(ContextAwarePredicate contextAwarePredicate, @NotNull String modId) {
            super(ID, contextAwarePredicate);
            this.modId = modId;
        }

        public static TriggerInstance involvedMod(String modId) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, modId);
        }

        private boolean matches(ItemStack stack) {
            String id = OEItemUtils.getCreatorModId(stack);
            return this.matches(id);
        }

        private boolean matches(String modId) {
            return this.modId.equals(modId);
        }

        public JsonObject m_7683_(@NotNull SerializationContext serializationContext) {
            JsonObject jo = super.m_7683_(serializationContext);
            jo.addProperty("modid", this.modId);
            return jo;
        }
    }
}

