/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.common;

import com.obscuria.obscureapi.registry.ObscureAPIEnchantments;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class DynamicProjectile
extends LivingEntity {
    private static final UUID BLANK_UUID = UUID.fromString("0-0-0-0-0");
    protected static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> SCALE_SPEED = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> RELATED_STACK = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> UNRELATED = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPIN = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> USES = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.m_135353_(DynamicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public Entity OWNER = null;

    public DynamicProjectile(EntityType<? extends DynamicProjectile> type, Level world) {
        super(type, world);
        this.m_20242_(true);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static void create(EntityType<? extends DynamicProjectile> type, Entity owner, Level level, @Nullable ItemStack stack, int damage, float offset, int lifetime, int maxUses) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (stack != null && stack.getEnchantmentLevel((Enchantment)ObscureAPIEnchantments.MIRROR.get()) > 0) {
                Entity projectile1 = type.m_20615_((Level)server);
                Entity projectile2 = type.m_20615_((Level)server);
                if (projectile1 instanceof DynamicProjectile) {
                    DynamicProjectile p1 = (DynamicProjectile)projectile1;
                    if (projectile2 instanceof DynamicProjectile) {
                        DynamicProjectile p2 = (DynamicProjectile)projectile2;
                        p1.defineOwner(owner, stack);
                        p2.defineOwner(owner, stack);
                        p1.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(offset));
                        p2.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(offset + 0.5f));
                        p1.m_20088_().m_135381_(LIFETIME, (Object)lifetime);
                        p2.m_20088_().m_135381_(LIFETIME, (Object)lifetime);
                        p1.m_20088_().m_135381_(USES, (Object)maxUses);
                        p2.m_20088_().m_135381_(USES, (Object)maxUses);
                        p1.m_20088_().m_135381_(DAMAGE, (Object)((int)Math.round((double)damage * 0.5)));
                        p2.m_20088_().m_135381_(DAMAGE, (Object)((int)Math.round((double)damage * 0.5)));
                        p1.m_7678_(owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() / 2.0f), owner.m_20189_(), 0.0f, 0.0f);
                        p2.m_7678_(owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() / 2.0f), owner.m_20189_(), 0.0f, 0.0f);
                        level.m_7967_((Entity)p1);
                        level.m_7967_((Entity)p2);
                    }
                }
            } else {
                Entity projectile = type.m_20615_((Level)server);
                if (projectile instanceof DynamicProjectile) {
                    DynamicProjectile p = (DynamicProjectile)projectile;
                    p.defineOwner(owner, stack);
                    p.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(offset));
                    p.m_20088_().m_135381_(LIFETIME, (Object)lifetime);
                    p.m_20088_().m_135381_(USES, (Object)maxUses);
                    p.m_20088_().m_135381_(DAMAGE, (Object)damage);
                    p.m_7678_(owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() / 2.0f), owner.m_20189_(), 0.0f, 0.0f);
                    level.m_7967_((Entity)p);
                }
            }
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(SCALE_SPEED, (Object)Float.valueOf(0.3f));
        this.m_20088_().m_135372_(OWNER_UUID, Optional.of(BLANK_UUID));
        this.m_20088_().m_135372_(OWNER_ID, (Object)0);
        this.m_20088_().m_135372_(RELATED_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(UNRELATED, (Object)false);
        this.m_20088_().m_135372_(SPIN, (Object)0);
        this.m_20088_().m_135372_(OFFSET, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(LIFETIME, (Object)0);
        this.m_20088_().m_135372_(USES, (Object)0);
        this.m_20088_().m_135372_(DAMAGE, (Object)0);
        super.m_8097_();
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        CompoundTag data = new CompoundTag();
        data.m_128350_("Scale", ((Float)this.m_20088_().m_135370_(SCALE)).floatValue());
        data.m_128350_("ScaleSpeed", ((Float)this.m_20088_().m_135370_(SCALE_SPEED)).floatValue());
        data.m_128362_("Owner", ((Optional)this.m_20088_().m_135370_(OWNER_UUID)).orElse(BLANK_UUID));
        data.m_128405_("OwnerID", ((Integer)this.m_20088_().m_135370_(OWNER_ID)).intValue());
        data.m_128365_("ItemStack", (Tag)((ItemStack)this.m_20088_().m_135370_(RELATED_STACK)).m_41739_(new CompoundTag()));
        data.m_128379_("Unrelated", ((Boolean)this.m_20088_().m_135370_(UNRELATED)).booleanValue());
        data.m_128405_("Spin", ((Integer)this.m_20088_().m_135370_(SPIN)).intValue());
        data.m_128350_("Offset", ((Float)this.m_20088_().m_135370_(OFFSET)).floatValue());
        data.m_128405_("LifeTime", ((Integer)this.m_20088_().m_135370_(LIFETIME)).intValue());
        data.m_128405_("Uses", ((Integer)this.m_20088_().m_135370_(USES)).intValue());
        data.m_128405_("Damage", ((Integer)this.m_20088_().m_135370_(DAMAGE)).intValue());
        tag.m_128365_("ProjectileData", (Tag)data);
        super.m_7380_(tag);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        CompoundTag data = (CompoundTag)tag.m_128423_("ProjectileData");
        if (data == null) {
            return;
        }
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(data.m_128457_("Scale")));
        this.m_20088_().m_135381_(SCALE_SPEED, (Object)Float.valueOf(data.m_128457_("ScaleSpeed")));
        this.m_20088_().m_135381_(OWNER_UUID, Optional.of(data.m_128342_("Owner")));
        this.m_20088_().m_135381_(OWNER_ID, (Object)data.m_128451_("OwnerID"));
        this.m_20088_().m_135381_(RELATED_STACK, (Object)ItemStack.m_41712_((CompoundTag)data.m_128469_("ItemStack")));
        this.m_20088_().m_135381_(UNRELATED, (Object)data.m_128471_("Unrelated"));
        this.m_20088_().m_135381_(SPIN, (Object)data.m_128451_("Spin"));
        this.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(data.m_128457_("Offset")));
        this.m_20088_().m_135381_(LIFETIME, (Object)data.m_128451_("LifeTime"));
        this.m_20088_().m_135381_(USES, (Object)data.m_128451_("Uses"));
        this.m_20088_().m_135381_(DAMAGE, (Object)data.m_128451_("Damage"));
        super.m_7378_(tag);
    }

    public void defineOwner(Entity entity, @Nullable ItemStack stack) {
        if (stack != null) {
            this.m_20088_().m_135381_(RELATED_STACK, (Object)stack);
        } else {
            this.m_20088_().m_135381_(UNRELATED, (Object)true);
        }
        this.m_20088_().m_135381_(OWNER_UUID, Optional.of(entity.m_20148_()));
        this.OWNER = entity;
    }

    public void m_8119_() {
        this.OWNER = this.m_9236_().m_6815_(((Integer)this.m_20088_().m_135370_(OWNER_ID)).intValue());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Entity owner = server.m_8791_(((Optional)this.m_20088_().m_135370_(OWNER_UUID)).orElse(BLANK_UUID));
            if (owner != null) {
                this.m_20088_().m_135381_(OWNER_ID, (Object)owner.m_19879_());
                this.OWNER = owner;
            }
            this.m_20088_().m_135381_(SPIN, (Object)((Integer)this.m_20088_().m_135370_(SPIN) + 1));
            this.m_20088_().m_135381_(LIFETIME, (Object)((Integer)this.m_20088_().m_135370_(LIFETIME) - 1));
            if (this.OWNER == null || !this.OWNER.m_6084_() || (Integer)this.m_20088_().m_135370_(USES) <= 0 || (Integer)this.m_20088_().m_135370_(LIFETIME) <= 0) {
                this.m_146870_();
            }
            if (this.OWNER != null) {
                this.updateMotion();
                List list = this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.m_20182_(), this.m_20182_()).m_82400_((double)this.getAttackRange()), e -> true);
                for (LivingEntity entities : list) {
                    if (entities == this.OWNER || !(entities.m_20182_().m_82554_(this.m_20182_()) <= (double)this.getAttackRange())) continue;
                    this.attack(entities);
                }
            }
        }
        super.m_8119_();
    }

    protected boolean attack(@Nonnull LivingEntity entity) {
        if (entity.m_6469_(this.OWNER instanceof LivingEntity ? this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.OWNER) : this.m_269291_().m_269425_(), (float)((Integer)this.m_20088_().m_135370_(DAMAGE)).intValue())) {
            this.m_20088_().m_135381_(USES, (Object)((Integer)this.m_20088_().m_135370_(USES) - 1));
            return true;
        }
        return false;
    }

    protected void updateMotion() {
        Vec3 center = this.OWNER.m_20182_().m_82520_(0.0, (double)this.OWNER.m_20206_() * 0.33, 0.0);
        float radius = this.getRadius();
        float speed = this.getSpinSpeed();
        float offset = this.getSpinOffset();
        Vec3 orbit = new Vec3(center.f_82479_ + Math.cos(speed + offset) * (double)radius, center.f_82480_, center.f_82481_ + Math.sin(speed + offset) * (double)radius);
        this.m_20219_(orbit);
    }

    protected float getAttackRange() {
        return 2.0f;
    }

    protected float getDefaultRadius() {
        return 4.0f;
    }

    protected float getDefaultSpinSpeed() {
        return 0.06f;
    }

    protected float getSpinSpeed() {
        float speed = this.getDefaultSpinSpeed();
        ItemStack stack = (ItemStack)this.m_20088_().m_135370_(RELATED_STACK);
        if (stack.m_41619_()) {
            return (float)((Integer)this.m_20088_().m_135370_(SPIN)).intValue() * speed;
        }
        return (float)((Integer)this.m_20088_().m_135370_(SPIN)).intValue() * (speed * (1.0f + 0.25f * (float)stack.getEnchantmentLevel((Enchantment)ObscureAPIEnchantments.FAST_SPIN.get())));
    }

    protected float getRadius() {
        float radius = this.getDefaultRadius();
        ItemStack stack = (ItemStack)this.m_20088_().m_135370_(RELATED_STACK);
        if (stack.m_41619_()) {
            return radius;
        }
        return radius * (1.0f + 0.2f * (float)stack.getEnchantmentLevel((Enchantment)ObscureAPIEnchantments.DISTANCE.get()));
    }

    protected float getSpinOffset() {
        return 6.315f * ((Float)this.m_20088_().m_135370_(OFFSET)).floatValue();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (!source.m_276093_(DamageTypes.f_268724_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_142535_(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    @Nonnull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    @Nonnull
    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    @Nonnull
    public ItemStack m_6844_(@Nonnull EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6783_(double d0) {
        double d1 = 100.0;
        return d0 < 10000.0;
    }
}

