/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureMountManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncTemperatureMountsPacket;

public class TemperatureMountListener
extends SimpleJsonResourceReloadListener
implements ITemperatureMountManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureResistance> TEMPERATURE_MOUNTS = new HashMap<ResourceLocation, JsonTemperatureResistance>();

    public TemperatureMountListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/mounts");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_MOUNTS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureResistance.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureResistance temperature = (JsonTemperatureResistance)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing temperature mount : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    TEMPERATURE_MOUNTS.put((ResourceLocation)key, temperature);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature mount json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature mounts", (Object)TEMPERATURE_MOUNTS.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncTemperatureMountsPacket.sendTo(packetTarget, TEMPERATURE_MOUNTS);
    }

    public static void acceptServerTemperatureMounts(Map<ResourceLocation, JsonTemperatureResistance> temperatureMounts) {
        TEMPERATURE_MOUNTS.clear();
        TEMPERATURE_MOUNTS.putAll(temperatureMounts);
    }

    @Override
    public JsonTemperatureResistance get(ResourceLocation mountRegistryName) {
        return TEMPERATURE_MOUNTS.get(mountRegistryName);
    }
}

