/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.jsonConfig;

import java.io.File;
import java.util.Map;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.common.integration.jsonConfig.JsonIntegrationConfig;
import sfiomn.legendarysurvivaloverhaul.config.JsonFileName;
import sfiomn.legendarysurvivaloverhaul.config.json_old.JsonConfigRegistration;

public class JsonIntegrationConfigRegistration {
    public static void init(File configDir) {
        JsonIntegrationConfigRegistration.registerIntegrationDefaults(configDir);
        JsonIntegrationConfigRegistration.processAllIntegrationsJson(configDir);
    }

    public static void registerIntegrationDefaults(File configDir) {
        if (LegendarySurvivalOverhaul.originsLoaded) {
            JsonIntegrationConfig.registerDefaultOriginsTemperature("origins:blazeborn", -5.0f, 15.0f, -2.0f, 0.0f);
            JsonIntegrationConfig.registerDefaultOriginsTemperature("origins:merling", 0.0f, 0.0f, 3.0f, 0.0f);
            JsonIntegrationConfig.registerDefaultOriginsTemperature("origins:arachnid", 0.0f, -5.0f, 0.0f, 0.0f);
            JsonIntegrationConfig.registerDefaultOriginsTemperature("origins:feline", 0.0f, 0.0f, 0.0f, 2.0f);
            JsonIntegrationConfig.registerDefaultOriginsTemperature("origins:enderian", 0.0f, 0.0f, 10.0f, 0.0f);
        }
    }

    public static void writeAllIntegrationsToJson(File jsonDir) {
        if (LegendarySurvivalOverhaul.originsLoaded) {
            JsonConfigRegistration.manuallyWriteToJson(JsonFileName.ORIGINS_TEMP, JsonIntegrationConfig.originsTemperatures, jsonDir);
        }
    }

    public static void deleteAllIntegrationsJson(File jsonDir) {
        JsonConfigRegistration.deleteJson(JsonFileName.ORIGINS_TEMP, jsonDir);
    }

    public static void processAllIntegrationsJson(File jsonDir) {
        Map jsonOriginsTemperatures = (Map)JsonConfigRegistration.processJson(JsonFileName.ORIGINS_TEMP, jsonDir);
        if (jsonOriginsTemperatures != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonOriginsTemperatures.size() + " origins temperature values from JSON");
            for (Map.Entry entry : jsonOriginsTemperatures.entrySet()) {
                JsonIntegrationConfig.registerOriginsTemperature((String)entry.getKey(), ((JsonTemperatureResistance)entry.getValue()).temperature, ((JsonTemperatureResistance)entry.getValue()).heatResistance, ((JsonTemperatureResistance)entry.getValue()).coldResistance, ((JsonTemperatureResistance)entry.getValue()).thermalResistance);
            }
        }
    }
}

