/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.jei;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.client.screens.SewingTableScreen;
import sfiomn.legendarysurvivaloverhaul.common.integration.jei.SewingRecipeCategory;
import sfiomn.legendarysurvivaloverhaul.common.integration.mutantmonsters.MutantMonstersUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.CoatItem;
import sfiomn.legendarysurvivaloverhaul.common.recipe.SewingRecipe;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.BlockRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;

@JeiPlugin
public class JeiIntegration
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("legendarysurvivaloverhaul", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (Config.Baked.temperatureEnabled) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SewingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (Config.Baked.thirstEnabled) {
            registration.registerSubtypeInterpreter((Item)ItemRegistry.CANTEEN.get(), (IIngredientSubtypeInterpreter)CanteenSubtypeInterpreter.INSTANCE);
            registration.registerSubtypeInterpreter((Item)ItemRegistry.LARGE_CANTEEN.get(), (IIngredientSubtypeInterpreter)CanteenSubtypeInterpreter.INSTANCE);
        }
        super.registerItemSubtypes(registration);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (Config.Baked.temperatureEnabled) {
            if (world != null) {
                RecipeManager rm = world.m_7465_();
                registration.addRecipes(SewingRecipeCategory.SEWING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)SewingRecipe.Type.INSTANCE).stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
            registration.addRecipes(SewingRecipeCategory.SEWING_RECIPE_TYPE, this.sewingCoatRecipes());
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (Config.Baked.temperatureEnabled) {
            registration.addRecipeClickArea(SewingTableScreen.class, 40, 37, 20, 20, new RecipeType[]{SewingRecipeCategory.SEWING_RECIPE_TYPE});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (Config.Baked.temperatureEnabled) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SEWING_TABLE.get()), new RecipeType[]{SewingRecipeCategory.SEWING_RECIPE_TYPE});
        }
    }

    private ArrayList<SewingRecipe> sewingCoatRecipes() {
        ArrayList<SewingRecipe> sewingRecipes = new ArrayList<SewingRecipe>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (item instanceof ArmorItem && ForgeRegistries.ITEMS.getKey((Object)item) != null) {
                this.addSewingRecipe(item, sewingRecipes);
                continue;
            }
            if (!MutantMonstersUtil.isMutantMonstersArmor(item) || ForgeRegistries.ITEMS.getKey((Object)item) == null) continue;
            this.addSewingRecipe(item, sewingRecipes);
        }
        return sewingRecipes;
    }

    private void addSewingRecipe(Item itemArmor, ArrayList<SewingRecipe> sewingRecipes) {
        ResourceLocation itemArmorRegistryName = ForgeRegistries.ITEMS.getKey((Object)itemArmor);
        for (RegistryObject modItem : ItemRegistry.ITEMS.getEntries()) {
            Object object = modItem.get();
            if (!(object instanceof CoatItem)) continue;
            CoatItem itemCoat = (CoatItem)((Object)object);
            if (itemArmorRegistryName == null) continue;
            ItemStack result = new ItemStack((ItemLike)itemArmor);
            TemperatureUtil.setArmorCoatTag(result, itemCoat.coat.id());
            sewingRecipes.add(this.getCoatRecipe("sewing_" + itemArmorRegistryName.m_135815_() + "_" + modItem.getId().m_135815_(), itemArmor, itemCoat, result));
        }
    }

    private SewingRecipe getCoatRecipe(String id, Item base, Item addition, ItemStack result) {
        return new SewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}), result, new ResourceLocation(id));
    }

    public static class CanteenSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final CanteenSubtypeInterpreter INSTANCE = new CanteenSubtypeInterpreter();

        private CanteenSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack, UidContext context) {
            if (!itemStack.m_41782_() || !Objects.requireNonNull(itemStack.m_41783_()).m_128441_("legendarysurvivaloverhaul:HydrationPurity")) {
                return "";
            }
            return itemStack.m_41783_().m_128461_("legendarysurvivaloverhaul:HydrationPurity");
        }
    }
}

