/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ITemperatureCapability;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.effects.FrostbiteEffect;
import sfiomn.legendarysurvivaloverhaul.common.effects.HeatStrokeEffect;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;

public class TemperatureCapability
implements ITemperatureCapability {
    private float temperature;
    private Set<Integer> temperatureImmunities;
    private int temperatureTickTimer;
    private int freezeTickTimer;
    private float oldTemperature;
    private float targetTemp;
    private boolean manualDirty;
    private int packetTimer;

    public TemperatureCapability() {
        this.init();
    }

    public void init() {
        this.temperature = TemperatureEnum.NORMAL.getMiddle();
        this.temperatureImmunities = new HashSet<Integer>();
        this.temperatureTickTimer = 0;
        this.freezeTickTimer = 0;
        this.oldTemperature = 0.0f;
        this.targetTemp = 0.0f;
        this.manualDirty = false;
        this.packetTimer = 0;
    }

    @Override
    public float getTemperatureLevel() {
        return this.temperature;
    }

    @Override
    public float getTargetTemperatureLevel() {
        return this.targetTemp;
    }

    @Override
    public int getTemperatureTickTimer() {
        return this.temperatureTickTimer;
    }

    @Override
    public int getFreezeTickTimer() {
        return this.freezeTickTimer;
    }

    @Override
    public void setTemperatureLevel(float temperature) {
        this.temperature = temperature;
    }

    @Override
    public void setTargetTemperatureLevel(float targetTemperature) {
        this.targetTemp = targetTemperature;
    }

    @Override
    public void setTemperatureTickTimer(int tickTimer) {
        this.temperatureTickTimer = tickTimer;
    }

    @Override
    public void setFreezeTickTimer(int tickTimer) {
        this.freezeTickTimer = tickTimer;
    }

    @Override
    public void addTemperatureLevel(float temperature) {
        this.setTemperatureLevel(this.getTemperatureLevel() + temperature);
    }

    @Override
    public void addTemperatureTickTimer(int tickTimer) {
        this.setTemperatureTickTimer(this.getTemperatureTickTimer() + tickTimer);
    }

    @Override
    public void addFreezeTickTimer(int tickTimer) {
        this.setFreezeTickTimer(Mth.m_14045_((int)(this.getFreezeTickTimer() + tickTimer), (int)0, (int)Config.Baked.maxFreezeEffectTick));
    }

    @Override
    public void addTemperatureImmunityId(int immunityId) {
        this.temperatureImmunities.add(immunityId);
    }

    @Override
    public void removeTemperatureImmunityId(int immunityId) {
        this.temperatureImmunities.remove(immunityId);
    }

    @Override
    public void tickUpdate(Player player, Level level, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START) {
            ++this.packetTimer;
            return;
        }
        this.addTemperatureTickTimer(1);
        if (player.m_203117_()) {
            this.addFreezeTickTimer(1);
        } else if (this.getFreezeTickTimer() > 0) {
            this.addFreezeTickTimer(-1);
        }
        if (this.getTemperatureTickTimer() >= Config.Baked.tempTickTime) {
            this.setTemperatureTickTimer(0);
            this.targetTemp = TemperatureUtil.getPlayerTargetTemperature(player);
            if (this.getTemperatureLevel() != this.targetTemp) {
                this.tickTemperature(this.getTemperatureLevel(), this.targetTemp);
            }
            TemperatureEnum tempEnum = this.getTemperatureEnum();
            if (player.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == Items.f_42751_) {
                LegendarySurvivalOverhaul.LOGGER.info(tempEnum + ", " + this.getTemperatureLevel() + " -> " + this.targetTemp);
            }
            this.applyDangerousEffects(player, tempEnum);
            this.applySecondaryEffects(player, tempEnum);
        }
    }

    @Override
    public void tickClient(Player player, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START) {
            return;
        }
        if (this.getTemperatureEnum() == TemperatureEnum.FROSTBITE && !FrostbiteEffect.playerIsImmuneToFrost(player)) {
            this.shakePlayer(player);
        }
    }

    private void applyDangerousEffects(Player player, TemperatureEnum tempEnum) {
        if (Config.Baked.dangerousHeatTemperature && ThirstUtil.isThirstActive(player) && tempEnum == TemperatureEnum.HEAT_STROKE) {
            if (TemperatureEnum.HEAT_STROKE.getMiddle() <= this.getTemperatureLevel() && !HeatStrokeEffect.playerIsImmuneToHeat(player)) {
                if (!player.m_21023_((MobEffect)MobEffectRegistry.HEAT_STROKE.get())) {
                    player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.HEAT_STROKE.get(), -1, 0, false, true));
                }
                return;
            }
        } else if (Config.Baked.dangerousColdTemperature && tempEnum == TemperatureEnum.FROSTBITE && TemperatureEnum.FROSTBITE.getMiddle() >= this.getTemperatureLevel() && !FrostbiteEffect.playerIsImmuneToFrost(player)) {
            if (!player.m_21023_((MobEffect)MobEffectRegistry.FROSTBITE.get())) {
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.FROSTBITE.get(), -1, 0, false, true));
            }
            return;
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.HEAT_STROKE.get())) {
            player.m_21195_((MobEffect)MobEffectRegistry.HEAT_STROKE.get());
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.FROSTBITE.get())) {
            player.m_21195_((MobEffect)MobEffectRegistry.FROSTBITE.get());
        }
    }

    private void applySecondaryEffects(Player player, TemperatureEnum tempEnum) {
        if (Config.Baked.heatTemperatureSecondaryEffects && tempEnum == TemperatureEnum.HEAT_STROKE) {
            if (!HeatStrokeEffect.playerIsImmuneToHeat(player)) {
                if (!player.m_21023_((MobEffect)MobEffectRegistry.HEAT_THIRST.get())) {
                    player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.HEAT_THIRST.get(), -1, 0, false, false));
                }
                return;
            }
        } else if (Config.Baked.coldTemperatureSecondaryEffects && tempEnum == TemperatureEnum.FROSTBITE && !FrostbiteEffect.playerIsImmuneToFrost(player)) {
            if (!player.m_21023_((MobEffect)MobEffectRegistry.COLD_HUNGER.get())) {
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.COLD_HUNGER.get(), -1, 0, false, false));
            }
            return;
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.HEAT_THIRST.get())) {
            player.m_21195_((MobEffect)MobEffectRegistry.HEAT_THIRST.get());
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.COLD_HUNGER.get())) {
            player.m_21195_((MobEffect)MobEffectRegistry.COLD_HUNGER.get());
        }
    }

    private void shakePlayer(Player player) {
        player.m_5618_(player.m_146908_() + (float)(Math.cos((double)player.f_19797_ * 3.25) * 1.25663706144));
    }

    private void tickTemperature(float currentTemp, float destination) {
        float diff = Math.abs(destination - currentTemp);
        double temperatureTowards = (double)diff * (Config.Baked.maxTemperatureModification - Config.Baked.minTemperatureModification) / (double)(TemperatureEnum.HEAT_STROKE.getUpperBound() - TemperatureEnum.FROSTBITE.getLowerBound()) + Config.Baked.minTemperatureModification;
        temperatureTowards = Math.min(temperatureTowards, (double)diff);
        if (currentTemp > destination) {
            this.addTemperatureLevel((float)(-temperatureTowards));
        } else {
            this.addTemperatureLevel((float)temperatureTowards);
        }
    }

    @Override
    public boolean isDirty() {
        return this.manualDirty || this.temperature != this.oldTemperature;
    }

    @Override
    public void setClean() {
        this.oldTemperature = this.temperature;
        this.manualDirty = false;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    @Override
    public TemperatureEnum getTemperatureEnum() {
        return TemperatureEnum.get(this.temperature);
    }

    @Override
    public List<Integer> getTemperatureImmunities() {
        return new ArrayList<Integer>(this.temperatureImmunities);
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("temperature", this.getTemperatureLevel());
        compound.m_128350_("targettemperature", this.getTargetTemperatureLevel());
        compound.m_128405_("ticktimer", this.getTemperatureTickTimer());
        compound.m_128405_("freezeticktimer", this.getFreezeTickTimer());
        compound.m_128408_("immunities", this.getTemperatureImmunities());
        return compound;
    }

    public void readNBT(CompoundTag compound) {
        this.init();
        if (compound.m_128441_("temperature")) {
            this.setTemperatureLevel(compound.m_128457_("temperature"));
        }
        if (compound.m_128441_("targettemperature")) {
            this.setTargetTemperatureLevel(compound.m_128457_("targettemperature"));
        }
        if (compound.m_128441_("tickTimer")) {
            this.setTemperatureTickTimer(compound.m_128451_("tickTimer"));
        }
        if (compound.m_128441_("freezeticktimer")) {
            this.setFreezeTickTimer(compound.m_128451_("freezeticktimer"));
        }
        if (compound.m_128441_("immunities")) {
            for (int immunityId : compound.m_128465_("immunities")) {
                this.addTemperatureImmunityId(immunityId);
            }
        }
    }
}

