/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.capabilities;

import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.bodydamage.BodyDamageCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.bodydamage.BodyDamageProvider;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.food.FoodCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.food.FoodProvider;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.health.HealthCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.health.HealthProvider;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureProvider;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstProvider;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness.WetnessCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness.WetnessProvider;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.network.packets.UpdateBodyDamagePacket;
import sfiomn.legendarysurvivaloverhaul.network.packets.UpdateHeartsPacket;
import sfiomn.legendarysurvivaloverhaul.network.packets.UpdateTemperaturesPacket;
import sfiomn.legendarysurvivaloverhaul.network.packets.UpdateThirstPacket;
import sfiomn.legendarysurvivaloverhaul.network.packets.UpdateWetnessPacket;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

@Mod.EventBusSubscriber(modid="legendarysurvivaloverhaul", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModCapabilities {
    public static final ResourceLocation TEMPERATURE_RES = new ResourceLocation("legendarysurvivaloverhaul", "temperature");
    public static final ResourceLocation WETNESS_RES = new ResourceLocation("legendarysurvivaloverhaul", "wetness");
    public static final ResourceLocation THIRST_RES = new ResourceLocation("legendarysurvivaloverhaul", "thirst");
    public static final ResourceLocation HEALTH_RES = new ResourceLocation("legendarysurvivaloverhaul", "health");
    public static final ResourceLocation FOOD_RES = new ResourceLocation("legendarysurvivaloverhaul", "food");
    public static final ResourceLocation BODY_DAMAGE_RES = new ResourceLocation("legendarysurvivaloverhaul", "body_damage");

    @SubscribeEvent
    public static void attachCapabilityPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object;
        if (event.getObject() instanceof LivingEntity && (object = event.getObject()) instanceof Player) {
            Player player = (Player)object;
            event.addCapability(TEMPERATURE_RES, (ICapabilityProvider)new TemperatureProvider());
            event.addCapability(WETNESS_RES, (ICapabilityProvider)new WetnessProvider());
            event.addCapability(THIRST_RES, (ICapabilityProvider)new ThirstProvider());
            event.addCapability(HEALTH_RES, (ICapabilityProvider)new HealthProvider());
            event.addCapability(FOOD_RES, (ICapabilityProvider)new FoodProvider());
            event.addCapability(BODY_DAMAGE_RES, (ICapabilityProvider)new BodyDamageProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient()) {
            Player player = event.player;
            if (ModCapabilities.shouldSkipTick(player)) {
                return;
            }
            if (Config.Baked.temperatureEnabled) {
                TemperatureCapability tempCap = CapabilityUtil.getTempCapability(player);
                tempCap.tickClient(player, event.phase);
            }
        } else {
            Player player = event.player;
            Level level = player.m_9236_();
            if (ModCapabilities.shouldSkipTick(player)) {
                return;
            }
            if (!Config.Baked.vanillaFreezeEnabled && player.m_146888_() > 0) {
                player.m_146917_(0);
            }
            if (Config.Baked.temperatureEnabled) {
                TemperatureCapability tempCap = CapabilityUtil.getTempCapability(player);
                tempCap.tickUpdate(player, level, event.phase);
                if (event.phase == TickEvent.Phase.START && (tempCap.isDirty() || tempCap.getPacketTimer() % Config.Baked.routinePacketSync == 0)) {
                    tempCap.setClean();
                    ModCapabilities.sendTemperatureUpdate(player);
                }
            }
            if (Config.Baked.wetnessEnabled) {
                WetnessCapability wetCap = CapabilityUtil.getWetnessCapability(player);
                wetCap.tickUpdate(player, level, event.phase);
                if (event.phase == TickEvent.Phase.START && (wetCap.getPacketTimer() % Config.Baked.routinePacketSync == 0 || wetCap.isDirty())) {
                    wetCap.setClean();
                    ModCapabilities.sendWetnessUpdate(player);
                }
            }
            if (Config.Baked.thirstEnabled) {
                ThirstCapability thirstCap = CapabilityUtil.getThirstCapability(player);
                thirstCap.tickUpdate(player, level, event.phase);
                if (event.phase == TickEvent.Phase.START && (thirstCap.isDirty() || thirstCap.getPacketTimer() % Config.Baked.routinePacketSync == 0)) {
                    thirstCap.setClean();
                    ModCapabilities.sendThirstUpdate(player);
                }
            }
            if (Config.Baked.baseFoodExhaustion > 0.0) {
                FoodCapability foodCapability = CapabilityUtil.getFoodCapability(player);
                foodCapability.tickUpdate(player, level, event.phase);
            }
            if (Config.Baked.localizedBodyDamageEnabled) {
                BodyDamageCapability bodyDamageCapability = CapabilityUtil.getBodyDamageCapability(player);
                bodyDamageCapability.tickUpdate(player, level, event.phase);
                if (event.phase == TickEvent.Phase.START && (bodyDamageCapability.isDirty() || bodyDamageCapability.getPacketTimer() % Config.Baked.routinePacketSync == 0)) {
                    bodyDamageCapability.setClean();
                    ModCapabilities.sendBodyDamageUpdate(player);
                }
            }
            if (Config.Baked.healthOverhaulEnabled) {
                HealthCapability healthCapability = CapabilityUtil.getHealthCapability(player);
                if (event.phase == TickEvent.Phase.START && healthCapability.isDirty()) {
                    healthCapability.setClean();
                    ModCapabilities.sendHealthUpdate(player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void deathHandler(PlayerEvent.Clone event) {
        Player orig = event.getOriginal();
        Player player = event.getEntity();
        if (event.isWasDeath()) {
            if (Config.Baked.localizedBodyDamageEnabled && Config.Baked.healthOverhaulEnabled) {
                BodyDamageUtil.updatePlayerBrokenHeartAttribute(player);
            }
            if (Config.Baked.temperatureEnabled) {
                player.getPersistentData().m_128379_("tempImmuneOnSpawn", orig.getPersistentData().m_128471_("tempImmuneOnSpawn"));
            }
            if (Config.Baked.healthOverhaulEnabled) {
                orig.reviveCaps();
                HealthCapability oldCap = CapabilityUtil.getHealthCapability(orig);
                orig.invalidateCaps();
                HealthCapability newCap = CapabilityUtil.getHealthCapability(player);
                newCap.readNBT(oldCap.writeNBT());
                HealthUtil.initializeHealthAttributes(player);
                if (Config.Baked.heartsLostOnDeath > 0) {
                    HealthUtil.loseHearth(player, Config.Baked.heartsLostOnDeath);
                } else {
                    HealthUtil.updatePlayerMaxHealthAttribute(player);
                }
                player.m_21153_(player.m_21233_());
            }
        } else {
            Object newCap;
            Object oldCap;
            if (Config.Baked.temperatureEnabled) {
                orig.reviveCaps();
                oldCap = CapabilityUtil.getTempCapability(orig);
                orig.invalidateCaps();
                newCap = CapabilityUtil.getTempCapability(player);
                ((TemperatureCapability)newCap).readNBT(((TemperatureCapability)oldCap).writeNBT());
                ModCapabilities.sendTemperatureUpdate(player);
            }
            if (Config.Baked.wetnessEnabled) {
                orig.reviveCaps();
                oldCap = CapabilityUtil.getWetnessCapability(orig);
                orig.invalidateCaps();
                newCap = CapabilityUtil.getWetnessCapability(player);
                ((WetnessCapability)newCap).readNBT(((WetnessCapability)oldCap).writeNBT());
                ModCapabilities.sendWetnessUpdate(player);
            }
            if (Config.Baked.thirstEnabled) {
                orig.reviveCaps();
                oldCap = CapabilityUtil.getThirstCapability(orig);
                orig.invalidateCaps();
                newCap = CapabilityUtil.getThirstCapability(player);
                ((ThirstCapability)newCap).readNBT(((ThirstCapability)oldCap).writeNBT());
                ModCapabilities.sendThirstUpdate(player);
            }
            if (Config.Baked.healthOverhaulEnabled) {
                orig.reviveCaps();
                oldCap = CapabilityUtil.getHealthCapability(orig);
                orig.invalidateCaps();
                newCap = CapabilityUtil.getHealthCapability(player);
                ((HealthCapability)newCap).readNBT(((HealthCapability)oldCap).writeNBT());
                HealthUtil.initializeHealthAttributes(player);
                HealthUtil.updatePlayerMaxHealthAttribute(player);
                player.m_21153_(player.m_21233_());
                ModCapabilities.sendHealthUpdate(player);
            }
            if (Config.Baked.localizedBodyDamageEnabled) {
                orig.reviveCaps();
                oldCap = CapabilityUtil.getBodyDamageCapability(orig);
                orig.invalidateCaps();
                newCap = CapabilityUtil.getBodyDamageCapability(player);
                ((BodyDamageCapability)newCap).readNBT(((BodyDamageCapability)oldCap).writeNBT());
                BodyDamageUtil.updatePlayerBrokenHeartAttribute(player);
                ModCapabilities.sendBodyDamageUpdate(player);
            }
        }
    }

    private static void sendTemperatureUpdate(Player player) {
        if (!player.m_9236_().m_5776_()) {
            UpdateTemperaturesPacket.sendTo(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Tag)CapabilityUtil.getTempCapability(player).writeNBT());
        }
    }

    private static void sendWetnessUpdate(Player player) {
        if (!player.m_9236_().f_46443_) {
            UpdateWetnessPacket.sendTo(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Tag)CapabilityUtil.getWetnessCapability(player).writeNBT());
        }
    }

    private static void sendThirstUpdate(Player player) {
        if (!player.m_9236_().f_46443_) {
            UpdateThirstPacket.sendTo(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Tag)CapabilityUtil.getThirstCapability(player).writeNBT());
        }
    }

    private static void sendBodyDamageUpdate(Player player) {
        if (!player.m_9236_().f_46443_) {
            UpdateBodyDamagePacket.sendTo(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Tag)CapabilityUtil.getBodyDamageCapability(player).writeNBT());
        }
    }

    private static void sendHealthUpdate(Player player) {
        if (!player.m_9236_().f_46443_) {
            UpdateHeartsPacket.sendTo(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Tag)CapabilityUtil.getHealthCapability(player).writeNBT());
        }
    }

    @SubscribeEvent
    public static void syncCapsOnDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (Config.Baked.temperatureEnabled) {
            ModCapabilities.sendTemperatureUpdate(player);
        }
        if (Config.Baked.wetnessEnabled) {
            ModCapabilities.sendWetnessUpdate(player);
        }
        if (Config.Baked.thirstEnabled) {
            ModCapabilities.sendThirstUpdate(player);
        }
        if (Config.Baked.healthOverhaulEnabled) {
            ModCapabilities.sendHealthUpdate(player);
        }
        if (Config.Baked.localizedBodyDamageEnabled) {
            ModCapabilities.sendBodyDamageUpdate(player);
        }
    }

    @SubscribeEvent
    public static void syncCapsOnLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (Config.Baked.temperatureEnabled) {
            ModCapabilities.sendTemperatureUpdate(player);
        }
        if (Config.Baked.wetnessEnabled) {
            ModCapabilities.sendWetnessUpdate(player);
        }
        if (Config.Baked.thirstEnabled) {
            ModCapabilities.sendThirstUpdate(player);
        }
        if (Config.Baked.healthOverhaulEnabled) {
            ModCapabilities.sendHealthUpdate(player);
        }
        if (Config.Baked.localizedBodyDamageEnabled) {
            ModCapabilities.sendBodyDamageUpdate(player);
        }
    }

    protected static boolean shouldSkipTick(Player player) {
        return player.m_7500_() || player.m_5833_();
    }
}

