/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sfiomn.legendarysurvivaloverhaul.client.shaders.FocusShader;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstCapability;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

@OnlyIn(value=Dist.CLIENT)
public class RenderBlurOverlay {
    private static FocusShader focusShader;
    private static final float DEFAULT_SHADER_INTENSITY = 0.0f;
    private static final float MAX_SHADER_INTENSITY = 4.0f;
    private static final float SHADER_INTENSITY_STEP = 0.05f;
    private static final int HYDRATION_LEVEL_MIN_EFFECT = 6;
    private static final int HYDRATION_LEVEL_MAX_EFFECT = 2;
    private static float shaderIntensity;
    private static int updateTimer;

    public static void render(Player player) {
        if (focusShader != null && (player.m_5833_() || player.m_7500_() || shaderIntensity == 0.0f)) {
            focusShader.stopRender();
            focusShader = null;
        } else if (shaderIntensity > 0.0f && !(Minecraft.m_91087_().f_91080_ instanceof DeathScreen)) {
            if (focusShader == null) {
                focusShader = new FocusShader();
            }
            focusShader.render(shaderIntensity);
        }
    }

    public static void updateBlurIntensity(@Nullable Player player) {
        float targetShaderIntensity = 0.0f;
        if (player != null && player.m_6084_() && !player.m_7500_() && !player.m_5833_()) {
            ThirstCapability thirstCap = CapabilityUtil.getThirstCapability(player);
            int hydration = thirstCap.getHydrationLevel();
            if (hydration <= 6) {
                targetShaderIntensity = (1.0f - (float)(hydration - 2) / 4.0f) * 4.0f;
            }
            if (updateTimer++ % 2 == 0) {
                if (targetShaderIntensity > shaderIntensity) {
                    shaderIntensity = Math.min(shaderIntensity + 0.05f, targetShaderIntensity);
                } else if (targetShaderIntensity < shaderIntensity) {
                    shaderIntensity = Math.max(shaderIntensity - 0.05f, targetShaderIntensity);
                }
            }
        } else {
            shaderIntensity = 0.0f;
        }
    }

    static {
        shaderIntensity = 0.0f;
        updateTimer = 0;
    }
}

