/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.data.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class JsonTemperatureBlock {
    public static final Codec<JsonTemperatureBlock> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("temperature").forGetter(c -> Float.valueOf(c.temperature)), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties", new HashMap()).forGetter(c -> c.properties)).apply((Applicative)inst, JsonTemperatureBlock::new));
    public static final Codec<List<JsonTemperatureBlock>> LIST_CODEC = CODEC.listOf();
    public float temperature;
    public Map<String, String> properties;

    public JsonTemperatureBlock(float temperature, Map<String, String> properties) {
        this.temperature = temperature;
        this.properties = new HashMap<String, String>();
        this.properties.putAll(properties);
    }

    public boolean isDefault() {
        return this.properties.isEmpty();
    }

    public boolean matchesBlockEntity(BlockEntity blockEntity) {
        CompoundTag blockEntityTag = blockEntity.m_187480_();
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            String name = property.getKey();
            if (blockEntityTag.m_128441_(name)) {
                String stateValue = String.valueOf(blockEntityTag.m_128423_(name));
                if (property.getValue().equalsIgnoreCase(stateValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean matchesState(BlockState blockState) {
        for (Property property : blockState.m_61147_()) {
            String name = property.m_61708_();
            if (!this.properties.containsKey(name)) continue;
            String stateValue = blockState.m_61143_(property).toString();
            if (this.properties.get(name).equalsIgnoreCase(stateValue)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesState(FluidState fluidState) {
        for (Property property : fluidState.m_61147_()) {
            String name = property.m_61708_();
            if (!this.properties.containsKey(name)) continue;
            String stateValue = fluidState.m_61143_(property).toString();
            if (this.properties.get(name).equalsIgnoreCase(stateValue)) continue;
            return false;
        }
        return true;
    }
}

