/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.bodydamage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum BodyPartEnum {
    HEAD,
    RIGHT_ARM,
    LEFT_ARM,
    CHEST,
    RIGHT_LEG,
    RIGHT_FOOT,
    LEFT_LEG,
    LEFT_FOOT;


    public List<BodyPartEnum> getNeighbours() {
        switch (this) {
            case HEAD: 
            case LEFT_ARM: 
            case RIGHT_ARM: {
                return Collections.singletonList(CHEST);
            }
            case CHEST: {
                return Arrays.asList(HEAD, LEFT_ARM, RIGHT_ARM, LEFT_LEG, RIGHT_LEG);
            }
            case LEFT_LEG: {
                return Arrays.asList(CHEST, RIGHT_LEG, LEFT_FOOT);
            }
            case LEFT_FOOT: {
                return Arrays.asList(LEFT_LEG, RIGHT_FOOT);
            }
            case RIGHT_LEG: {
                return Arrays.asList(CHEST, LEFT_LEG, RIGHT_FOOT);
            }
            case RIGHT_FOOT: {
                return Arrays.asList(RIGHT_LEG, LEFT_FOOT);
            }
        }
        return Collections.emptyList();
    }

    public static BodyPartEnum get(String name) {
        for (BodyPartEnum b : BodyPartEnum.values()) {
            if (!b.name().equalsIgnoreCase(name)) continue;
            return b;
        }
        throw new IllegalArgumentException();
    }
}

