/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.progwml6.ironshulkerbox.client.model.IronShulkerBoxesModels;
import com.progwml6.ironshulkerbox.client.model.inventory.ModelItem;
import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.ICrystalShulkerBox;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IronShulkerBoxRenderer
implements BlockEntityRenderer<AbstractIronShulkerBoxBlockEntity> {
    private final ShulkerModel<?> model;
    private final BlockEntityRenderDispatcher renderer;
    private static final List<ModelItem> MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));

    public IronShulkerBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ShulkerModel(context.m_173582_(ModelLayers.f_171180_));
        this.renderer = context.m_173581_();
    }

    public void render(AbstractIronShulkerBoxBlockEntity tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        DyeColor dyecolor;
        Level level;
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (tileEntityIn.m_58898_() && tileEntityIn.m_58904_() != null && (blockstate = tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_())).m_60734_() instanceof AbstractIronShulkerBoxBlock) {
            direction = (Direction)blockstate.m_61143_(AbstractIronShulkerBoxBlock.FACING);
        }
        boolean useTileEntityBlockState = (level = tileEntityIn.m_58904_()) != null;
        BlockState blockState = useTileEntityBlockState ? tileEntityIn.m_58900_() : (BlockState)tileEntityIn.getBlockToUse().m_49966_().m_61124_(AbstractIronShulkerBoxBlock.FACING, (Comparable)Direction.UP);
        Block block = blockState.m_60734_();
        IronShulkerBoxesTypes boxType = IronShulkerBoxesTypes.IRON;
        IronShulkerBoxesTypes typeFromTileEntity = tileEntityIn.getShulkerBoxType();
        IronShulkerBoxesTypes typeFromBlock = AbstractIronShulkerBoxBlock.getTypeFromBlock(block);
        if (typeFromTileEntity != null) {
            boxType = typeFromTileEntity;
        }
        if ((boxType != typeFromBlock || typeFromTileEntity != typeFromBlock) && typeFromBlock != null) {
            boxType = typeFromBlock;
        }
        Material material = (dyecolor = tileEntityIn.getColor()) == null ? new Material(Sheets.f_110735_, IronShulkerBoxesModels.chooseShulkerBoxTexture(boxType)) : new Material(Sheets.f_110735_, IronShulkerBoxesModels.chooseShulkerBoxTexture(boxType, dyecolor.m_41060_()));
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_85841_(0.9995f, 0.9995f, 0.9995f);
        poseStack.m_252781_(direction.m_253075_());
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        ModelPart modelpart = this.model.m_103742_();
        modelpart.m_104227_(0.0f, 24.0f - tileEntityIn.getProgress(partialTicks) * 0.5f * 16.0f, 0.0f);
        modelpart.f_104204_ = 270.0f * tileEntityIn.getProgress(partialTicks) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.m_119194_(bufferSource, RenderType::m_110458_);
        this.model.m_7695_(poseStack, vertexconsumer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (boxType.isTransparent() && tileEntityIn instanceof ICrystalShulkerBox) {
            ICrystalShulkerBox crystalShulkerBox = (ICrystalShulkerBox)((Object)tileEntityIn);
            if (Vec3.m_82512_((Vec3i)tileEntityIn.m_58899_()).m_82509_((Position)this.renderer.f_112249_.m_90583_(), 128.0)) {
                float rotation = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
                for (int j = 0; j < MODEL_ITEMS.size() - 1; ++j) {
                    IronShulkerBoxRenderer.renderItem(poseStack, bufferSource, (ItemStack)crystalShulkerBox.getTopItems().get(j), MODEL_ITEMS.get(j), rotation, combinedLightIn);
                }
            }
        }
    }

    public static void renderItem(PoseStack matrices, MultiBufferSource buffer, ItemStack item, ModelItem modelItem, float rotation, int light) {
        if (item.m_41619_()) {
            return;
        }
        matrices.m_85836_();
        Vector3f center = modelItem.getCenter();
        matrices.m_252880_(center.x(), center.y(), center.z());
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float scale = modelItem.getSizeScaled();
        matrices.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91291_().m_269128_(item, ItemDisplayContext.NONE, light, OverlayTexture.f_118083_, matrices, buffer, null, 0);
        matrices.m_85849_();
    }
}

