/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipeRegistry;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.CauldronPlatformHelper;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.jei.AlchemistCauldronJeiRecipe;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public final class AlchemistCauldronRecipeMaker {
    private AlchemistCauldronRecipeMaker() {
    }

    public static List<AlchemistCauldronJeiRecipe> getRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.of(AlchemistCauldronRecipeMaker.getScrollRecipes(vanillaRecipeFactory, ingredientManager), AlchemistCauldronRecipeMaker.getCustomRecipes(vanillaRecipeFactory, ingredientManager), AlchemistCauldronRecipeMaker.getPotionRecipes(vanillaRecipeFactory, ingredientManager)).flatMap(x -> x).toList();
    }

    private static Stream<AlchemistCauldronJeiRecipe> getScrollRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Arrays.stream(SpellRarity.values()).map(AlchemistCauldronRecipeMaker::enumerateSpellsForRarity);
    }

    private static Stream<AlchemistCauldronJeiRecipe> getCustomRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        List<ItemStack> reagents = ingredientManager.getAllItemStacks().stream().filter(AlchemistCauldronRecipeRegistry::isValidIngredient).toList();
        return reagents.stream().flatMap(reagentStack -> AlchemistCauldronRecipeRegistry.getRecipes().stream().filter(recipe -> CauldronPlatformHelper.itemMatches(reagentStack, recipe.getIngredient())).map(recipe -> {
            ItemStack result = recipe.getResult();
            if (result.m_41613_() == 4) {
                result.m_41764_(1);
            }
            return new AlchemistCauldronJeiRecipe(List.of(reagentStack), List.of(result), List.of(recipe.getInput()));
        }));
    }

    private static Stream<AlchemistCauldronJeiRecipe> getPotionRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        if (!((Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get()).booleanValue()) {
            return Stream.of(new AlchemistCauldronJeiRecipe[0]);
        }
        List<ItemStack> potionReagents = ingredientManager.getAllItemStacks().stream().filter(AlchemistCauldronRecipeMaker::isIngredient).toList();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return Stream.of(new AlchemistCauldronJeiRecipe[0]);
        }
        return potionReagents.stream().flatMap(reagentStack -> ingredientManager.getAllItemStacks().stream().filter(itemStack -> itemStack.m_41720_() instanceof PotionItem && BrewingRecipeRegistry.hasOutput((ItemStack)itemStack, (ItemStack)reagentStack)).map(baseItem -> new AlchemistCauldronJeiRecipe(List.of(reagentStack), List.of(BrewingRecipeRegistry.getOutput((ItemStack)baseItem, (ItemStack)reagentStack)), List.of(baseItem))));
    }

    private static AlchemistCauldronJeiRecipe enumerateSpellsForRarity(SpellRarity spellRarity) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> catalysts = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        SpellRegistry.getEnabledSpells().forEach(spell -> IntStream.rangeClosed(spell.getMinLevel(), spell.getMaxLevel()).filter(spellLevel -> spell.getRarity(spellLevel) == spellRarity).forEach(filteredLevel -> inputs.add(AlchemistCauldronRecipeMaker.getScrollStack(scrollStack, spell, filteredLevel))));
        ItemStack ink = new ItemStack((ItemLike)InkItem.getInkForRarity(spellRarity));
        ItemStack waterBottle = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)waterBottle, (Potion)Potions.f_43599_);
        inputs.forEach(itemStack -> {
            catalysts.add(waterBottle);
            outputs.add(ink);
        });
        return new AlchemistCauldronJeiRecipe(inputs, outputs, catalysts);
    }

    private static ItemStack getScrollStack(ItemStack stack, AbstractSpell spell, int spellLevel) {
        ItemStack scrollStack = stack.m_41777_();
        ISpellContainer.createScrollContainer(spell, spellLevel, scrollStack);
        return scrollStack;
    }

    private static boolean isIngredient(ItemStack itemStack) {
        try {
            return CauldronPlatformHelper.isBrewingIngredient(itemStack, (Level)Minecraft.m_91087_().f_91073_);
        }
        catch (LinkageError | RuntimeException e) {
            IronsSpellbooks.LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStack.toString(), (Object)e);
            return false;
        }
    }
}

