/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.net.okhttp;

import java.io.IOException;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.net.download.DownloadListener;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Requires(value="com.squareup.okhttp3:okhttp")
public class ProgressForwardingSource
extends ForwardingSource {
    private final DownloadListener listener;
    private long totalLen;

    public ProgressForwardingSource(Source delegate, DownloadListener listener) {
        this(delegate, listener, 0L);
    }

    public ProgressForwardingSource(Source delegate, DownloadListener listener, long existingLen) {
        super(delegate);
        this.listener = listener;
        this.totalLen = existingLen;
    }

    public long read(@NotNull Buffer sink, long byteCount) throws IOException {
        long len = super.read(sink, byteCount);
        if (len == -1L) {
            this.listener.finish(this.totalLen);
        } else {
            this.totalLen += len;
            this.listener.update(this.totalLen);
        }
        return len;
    }
}

