/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class Music
implements TagSerializable,
IIMPComparable {
    private UUID uuid;
    private String name;
    private String author;
    private MusicSource source;
    private ImageInfo image;
    private UUID owner;
    private long createDate;

    public Music() {
    }

    public Music(UUID uuid, String name, String author, MusicSource source, ImageInfo image, UUID owner, long createDate) {
        this.uuid = uuid;
        this.name = name;
        this.author = author;
        this.source = source;
        this.image = image;
        this.owner = owner;
        this.createDate = createDate;
    }

    public void save(CompoundTag tag) {
        tag.m_128362_("UUID", this.uuid);
        tag.m_128359_("Name", this.name);
        tag.m_128359_("Author", this.author);
        tag.m_128365_("Source", (Tag)this.source.createSavedTag());
        tag.m_128365_("Image", (Tag)this.image.createSavedTag());
        tag.m_128362_("Owner", this.owner);
        tag.m_128356_("CreateDate", this.createDate);
    }

    public void load(CompoundTag tag) {
        this.uuid = tag.m_128342_("UUID");
        this.name = tag.m_128461_("Name");
        this.author = tag.m_128461_("Author");
        this.source = (MusicSource)TagSerializable.loadSavedTag((CompoundTag)tag.m_128469_("Source"), (TagSerializable)new MusicSource());
        this.image = (ImageInfo)TagSerializable.loadSavedTag((CompoundTag)tag.m_128469_("Image"), (TagSerializable)new ImageInfo());
        this.owner = tag.m_128342_("Owner");
        this.createDate = tag.m_128454_("CreateDate");
    }

    public String getName() {
        return this.name;
    }

    public ImageInfo getImage() {
        return this.image;
    }

    public MusicSource getSource() {
        return this.source;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public long getCreateDate() {
        return this.createDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Music music = (Music)o;
        return this.createDate == music.createDate && Objects.equals(this.uuid, music.uuid) && Objects.equals(this.name, music.name) && Objects.equals(this.author, music.author) && Objects.equals(this.source, music.source) && Objects.equals(this.image, music.image) && Objects.equals(this.owner, music.owner);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.name, this.author, this.source, this.image, this.owner, this.createDate);
    }

    public String toString() {
        return "Music{uuid=" + String.valueOf(this.uuid) + ", name='" + this.name + "', author='" + this.author + "', source=" + String.valueOf(this.source) + ", image=" + String.valueOf(this.image) + ", owner=" + String.valueOf(this.owner) + ", createDate=" + this.createDate + "}";
    }

    @Override
    public String getCompareName() {
        return this.name;
    }

    @Override
    public String getComparePlayerName() {
        return this.owner.toString();
    }

    @Override
    public long getCompareDate() {
        return this.createDate;
    }
}

