/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music;

import dev.felnull.imp.api.MusicSpeakerInfoAccess;
import dev.felnull.imp.client.util.MusicUtils;
import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public record MusicSpeakerInfo(Vec3 position, float volume, float range, MusicSpeakerFixedInfo fixedInfo) implements MusicSpeakerInfoAccess
{
    public MusicSpeakerInfo() {
        this(Vec3.f_82478_, 0.0f, 0.0f, new MusicSpeakerFixedInfo());
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", this.position.f_82479_);
        tag.m_128347_("y", this.position.f_82480_);
        tag.m_128347_("z", this.position.f_82481_);
        tag.m_128350_("volume", this.volume);
        tag.m_128350_("range", this.range);
        tag.m_128365_("fixed_info", (Tag)this.fixedInfo.toTag());
        return tag;
    }

    public static MusicSpeakerInfo loadByTag(CompoundTag tag) {
        Vec3 position = new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
        float volume = tag.m_128457_("volume");
        float range = tag.m_128457_("range");
        MusicSpeakerFixedInfo fixedInfo = MusicSpeakerFixedInfo.loadByTag(tag.m_128469_("fixed_info"));
        return new MusicSpeakerInfo(position, volume, range, fixedInfo);
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public int getChannel() {
        return this.fixedInfo().channel();
    }

    @Override
    public boolean isSpatial() {
        return MusicUtils.isSpatial(this.fixedInfo.spatialType());
    }
}

