/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.org.apache.http.protocol;

import dev.felnull.imp.include.org.apache.http.HttpEntityEnclosingRequest;
import dev.felnull.imp.include.org.apache.http.HttpException;
import dev.felnull.imp.include.org.apache.http.HttpRequest;
import dev.felnull.imp.include.org.apache.http.HttpRequestInterceptor;
import dev.felnull.imp.include.org.apache.http.annotation.Contract;
import dev.felnull.imp.include.org.apache.http.annotation.ThreadingBehavior;
import dev.felnull.imp.include.org.apache.http.protocol.HttpContext;
import dev.felnull.imp.include.org.apache.http.protocol.HttpDateGenerator;
import dev.felnull.imp.include.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

