/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube.track.format;

import dev.felnull.imp.include.dev.lavalink.youtube.track.format.FormatInfo;
import dev.felnull.imp.include.dev.lavalink.youtube.track.format.StreamFormat;
import java.util.List;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public class TrackFormats {
    private final List<StreamFormat> formats;
    private final String playerScriptUrl;

    public TrackFormats(@NotNull List<StreamFormat> formats, @NotNull String playerScriptUrl) {
        this.formats = formats;
        this.playerScriptUrl = playerScriptUrl;
    }

    @NotNull
    public List<StreamFormat> getFormats() {
        return this.formats;
    }

    @NotNull
    public String getPlayerScriptUrl() {
        return this.playerScriptUrl;
    }

    @NotNull
    public StreamFormat getBestFormat() {
        StreamFormat bestFormat = null;
        for (StreamFormat format2 : this.formats) {
            if (!format2.isDefaultAudioTrack() || !TrackFormats.isBetterFormat(format2, bestFormat)) continue;
            bestFormat = format2;
        }
        if (bestFormat == null) {
            StringJoiner joiner = new StringJoiner(", ");
            this.formats.forEach(format -> joiner.add(format.getType().toString()));
            throw new RuntimeException("No supported audio streams available, available types: " + joiner);
        }
        return bestFormat;
    }

    private static boolean isBetterFormat(StreamFormat format, StreamFormat other) {
        FormatInfo info = format.getInfo();
        if (info == null) {
            return false;
        }
        if (other == null) {
            return true;
        }
        if ("audio/webm".equals(info.mimeType) && format.getAudioChannels() > 2L) {
            return false;
        }
        if (info.ordinal() != other.getInfo().ordinal()) {
            return info.ordinal() < other.getInfo().ordinal();
        }
        if (format.isDrc() && !other.isDrc()) {
            return false;
        }
        return format.getBitrate() > other.getBitrate();
    }
}

