/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.getyarn.GetyarnAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.local.LocalAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.nico.NicoAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import java.util.Set;

public class AudioSourceManagers {
    public static void registerRemoteSources(AudioPlayerManager playerManager) {
        AudioSourceManagers.registerRemoteSources(playerManager, MediaContainerRegistry.DEFAULT_REGISTRY);
    }

    public static void registerRemoteSources(AudioPlayerManager playerManager, MediaContainerRegistry containerRegistry) {
        playerManager.registerSourceManager(new YoutubeAudioSourceManager(true, null, null));
        playerManager.registerSourceManager(new YandexMusicAudioSourceManager(true));
        playerManager.registerSourceManager(SoundCloudAudioSourceManager.createDefault());
        playerManager.registerSourceManager(new BandcampAudioSourceManager());
        playerManager.registerSourceManager(new VimeoAudioSourceManager());
        playerManager.registerSourceManager(new TwitchStreamAudioSourceManager());
        playerManager.registerSourceManager(new BeamAudioSourceManager());
        playerManager.registerSourceManager(new GetyarnAudioSourceManager());
        playerManager.registerSourceManager(new NicoAudioSourceManager());
        playerManager.registerSourceManager(new HttpAudioSourceManager(containerRegistry));
    }

    @SafeVarargs
    public static void registerRemoteSources(AudioPlayerManager playerManager, Class<? extends AudioSourceManager> ... excludedSources) {
        AudioSourceManagers.registerRemoteSources(playerManager, MediaContainerRegistry.DEFAULT_REGISTRY, excludedSources);
    }

    @SafeVarargs
    public static void registerRemoteSources(AudioPlayerManager playerManager, MediaContainerRegistry containerRegistry, Class<? extends AudioSourceManager> ... excludedSources) {
        Set<Class<? extends AudioSourceManager>> excluded = Set.of(excludedSources);
        if (!excluded.contains(YoutubeAudioSourceManager.class)) {
            playerManager.registerSourceManager(new YoutubeAudioSourceManager(true, null, null));
        }
        if (!excluded.contains(YandexMusicAudioSourceManager.class)) {
            playerManager.registerSourceManager(new YandexMusicAudioSourceManager(true));
        }
        if (!excluded.contains(SoundCloudAudioSourceManager.class)) {
            playerManager.registerSourceManager(SoundCloudAudioSourceManager.createDefault());
        }
        if (!excluded.contains(BandcampAudioSourceManager.class)) {
            playerManager.registerSourceManager(new BandcampAudioSourceManager());
        }
        if (!excluded.contains(VimeoAudioSourceManager.class)) {
            playerManager.registerSourceManager(new VimeoAudioSourceManager());
        }
        if (!excluded.contains(TwitchStreamAudioSourceManager.class)) {
            playerManager.registerSourceManager(new TwitchStreamAudioSourceManager());
        }
        if (!excluded.contains(BeamAudioSourceManager.class)) {
            playerManager.registerSourceManager(new BeamAudioSourceManager());
        }
        if (!excluded.contains(GetyarnAudioSourceManager.class)) {
            playerManager.registerSourceManager(new GetyarnAudioSourceManager());
        }
        if (!excluded.contains(NicoAudioSourceManager.class)) {
            playerManager.registerSourceManager(new NicoAudioSourceManager());
        }
        if (!excluded.contains(HttpAudioSourceManager.class)) {
            playerManager.registerSourceManager(new HttpAudioSourceManager(containerRegistry));
        }
    }

    public static void registerLocalSource(AudioPlayerManager playerManager) {
        AudioSourceManagers.registerLocalSource(playerManager, MediaContainerRegistry.DEFAULT_REGISTRY);
    }

    public static void registerLocalSource(AudioPlayerManager playerManager, MediaContainerRegistry containerRegistry) {
        playerManager.registerSourceManager(new LocalAudioSourceManager(containerRegistry));
    }
}

