/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.player;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public record MusicInstantaneous(long sampleTime, List<ChannelInstantaneous> channelInstantaneous) {
    public static MusicInstantaneous create(long time, byte[] data, int channel, int bit) {
        ArrayList<ChannelInstantaneous> cis = new ArrayList<ChannelInstantaneous>();
        for (int i = 0; i < channel; ++i) {
            cis.add(new ChannelInstantaneous(new float[60]));
        }
        if (bit != 16) {
            throw new RuntimeException("Unsupported bit");
        }
        int ovs = data.length / 2;
        int oct = ovs / 60 / channel;
        for (int i = 0; i < 60; ++i) {
            int j;
            float[] totals = new float[channel];
            for (j = 0; j < oct; ++j) {
                int l = (oct * i + j) * (2 * channel);
                int k = 0;
                while (k < channel) {
                    int l1 = l + 2 * k;
                    int l2 = l1 + 1;
                    byte[] d = new byte[]{data[l1], data[l2]};
                    short r = ByteBuffer.wrap(d).order(ByteOrder.LITTLE_ENDIAN).getShort();
                    float val = Math.abs((float)r / 32767.0f);
                    int n = k++;
                    totals[n] = totals[n] + val;
                }
            }
            for (j = 0; j < totals.length; ++j) {
                ((ChannelInstantaneous)cis.get((int)j)).waves[i] = totals[j] / (float)(oct / channel);
            }
        }
        return new MusicInstantaneous(time, cis);
    }

    public float[] getWaves(int channel) {
        return this.channelInstantaneous.get((int)channel).waves;
    }

    public record ChannelInstantaneous(float[] waves) {
    }
}

