/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayListBaseMMMonitor
extends ImageNameBaseMMMonitor {
    protected static final Component PUBLIC_ST_TEXT = Component.m_237115_((String)"imp.text.publishingSettings");
    protected static final Component INITIAL_AUTHORITY_TEXT = Component.m_237115_((String)"imp.text.initialAuthority");
    protected static final Component PUBLIC_RDO_TEXT = Component.m_237115_((String)"imp.radioButton.public");
    protected static final Component PRIVATE_RDO_TEXT = Component.m_237115_((String)"imp.radioButton.private");
    protected static final Component READONLY_RDO_TEXT = Component.m_237115_((String)"imp.radioButton.readonly");
    protected static final Component MEMBER_RDO_TEXT = Component.m_237115_((String)"imp.radioButton.member");

    public PlayListBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void render(GuiGraphics guiGraphics, float f, int mouseX, int mouseY) {
        super.render(guiGraphics, f, mouseX, mouseY);
        this.drawSmartText(guiGraphics, PUBLIC_ST_TEXT, this.getStartX() + 5, this.getStartY() + 131);
        this.drawSmartText(guiGraphics, INITIAL_AUTHORITY_TEXT, this.getStartX() + 189, this.getStartY() + 131);
        this.drawSmartText(guiGraphics, this.getPlayerListName(), this.getStartX() + 189, this.getStartY() + 13);
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartTextSprite(poseStack, multiBufferSource, PUBLIC_ST_TEXT, 5.0f, 131.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartTextSprite(poseStack, multiBufferSource, INITIAL_AUTHORITY_TEXT, 189.0f, 131.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartTextSprite(poseStack, multiBufferSource, this.getPlayerListName(), 189.0f, 13.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
    }

    @Nullable
    protected PublishingType getPublishingType() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            return this.getPublishingType(musicManagerBlock);
        }
        return null;
    }

    @Nullable
    protected PublishingType getPublishingType(MusicManagerBlockEntity musicManagerBlockEntity) {
        return PublishingType.getTypeByName(musicManagerBlockEntity.getPublishing((Player)PlayListBaseMMMonitor.mc.f_91074_));
    }

    @Nullable
    protected InitialAuthorityType getInitialAuthorityType() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            return this.getInitialAuthorityType(musicManagerBlock);
        }
        return null;
    }

    @Nullable
    protected InitialAuthorityType getInitialAuthorityType(MusicManagerBlockEntity musicManagerBlockEntity) {
        return InitialAuthorityType.getTypeByName(musicManagerBlockEntity.getInitialAuthority((Player)PlayListBaseMMMonitor.mc.f_91074_));
    }

    @NotNull
    protected String getInvitePlayerName(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getInvitePlayerName((Player)PlayListBaseMMMonitor.mc.f_91074_);
    }

    @NotNull
    protected String getInvitePlayerName() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            return this.getInvitePlayerName(musicManagerBlock);
        }
        return "";
    }

    @NotNull
    protected List<UUID> getInvitePlayers() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            return this.getInvitePlayers(musicManagerBlock);
        }
        return Collections.emptyList();
    }

    @NotNull
    protected List<UUID> getInvitePlayers(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getInvitePlayers((Player)PlayListBaseMMMonitor.mc.f_91074_);
    }

    protected abstract Component getPlayerListName();

    protected static enum PublishingType {
        PUBLIC("public"),
        PRIVATE("private");

        private final String name;

        private PublishingType(String name) {
            this.name = name;
        }

        public static PublishingType getTypeByName(String type) {
            for (PublishingType value : PublishingType.values()) {
                if (!value.name.equals(type)) continue;
                return value;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }

    protected static enum InitialAuthorityType {
        READ_ONLY("read_only"),
        MEMBER("member");

        private final String name;

        private InitialAuthorityType(String name) {
            this.name = name;
        }

        public static InitialAuthorityType getTypeByName(String type) {
            for (InitialAuthorityType value : InitialAuthorityType.values()) {
                if (!value.name.equals(type)) continue;
                return value;
            }
            return null;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

