/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.DeleteBaseMMMonitor;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.networking.existence.BlockEntityExistence;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeletePlayListMMMonitor
extends DeleteBaseMMMonitor {
    public DeletePlayListMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void onDelete() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            NetworkManager.sendToServer((ResourceLocation)IMPPackets.MUSIC_OR_PLAYLIST_DELETE, (FriendlyByteBuf)new IMPPackets.MusicOrPlayListDeleteMessage(this.getSelectedPlayList(musicManagerBlock), UUID.randomUUID(), BlockEntityExistence.getByBlockEntity((BlockEntity)this.getScreen().getBlockEntity()), false).toFBB());
        }
    }

    @Override
    @NotNull
    public String getWaringName(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList mp = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (mp != null) {
            return mp.getName();
        }
        return "";
    }

    @Override
    @Nullable
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.DETAIL_PLAY_LIST;
    }

    protected MusicPlayList getSelectedMusicPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        if (pls == null) {
            return null;
        }
        return this.getSyncManager().getMyPlayList().stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList(musicManagerBlockEntity))).findFirst().orElse(null);
    }

    protected UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getSelectedPlayList((Player)DeletePlayListMMMonitor.mc.f_91074_);
    }
}

