/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.FaunifyConfig;
import com.pepper.faunify.entity.RingtailCatEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class RingtailCatModel
extends DefaultedEntityGeoModel<RingtailCatEntity> {
    public RingtailCatModel() {
        super(new ResourceLocation("faunify", "ringtailcat"), true);
    }

    public ResourceLocation getAnimationResource(RingtailCatEntity object) {
        if (((Boolean)FaunifyConfig.OLD_ANIMATION.get()).booleanValue()) {
            return new ResourceLocation("faunify", "animations/ringtailcat.animation.json");
        }
        return new ResourceLocation("faunify", "animations/ratringtailcat.animation.json");
    }

    public void setCustomAnimations(RingtailCatEntity entity, long instanceId, AnimationState<RingtailCatEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone neck = this.getAnimationProcessor().getBone("head_rotation");
        boolean moving = animationState.isMoving();
        if (head != null) {
            if (entity.m_6162_()) {
                head.setScaleX(1.4f);
                head.setScaleY(1.4f);
                head.setScaleZ(1.4f);
            } else {
                head.setScaleX(1.0f);
                head.setScaleY(1.0f);
                head.setScaleZ(1.0f);
            }
            if (!entity.m_5803_()) {
                if (this.turnsHead) {
                    head.setRotX(extraDataOfType.headPitch() * 0.3f * ((float)Math.PI / 180));
                    head.setRotY(extraDataOfType.netHeadYaw() * 0.3f * ((float)Math.PI / 180));
                }
            } else if (entity.m_5803_()) {
                head.setRotX(0.0f);
                head.setRotY(0.0f);
            }
        }
        if (entity.m_5803_()) {
            return;
        }
        if (neck != null && head != null && !entity.isShrieking() && !entity.m_5803_()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * 0.3f * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * 0.3f * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * 0.3f * ((float)Math.PI / 180) * -0.5f);
        } else if (neck != null && entity.m_5803_()) {
            neck.setRotX(0.0f);
            neck.setRotZ(0.0f);
        }
    }
}

