/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.MouseEntity;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class OpossumEntity
extends Animal
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 15.0f;
    private static final int HOLDING_DURATION = 1200;
    private static final int EATING_DURATION = 120;
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BABY_COUNT = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_RIDDEN = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RIDING_COOLDOWN = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PLAYING_DEAD = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PLAY_DEAD_COOLDOWN = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_PLAY_DEAD = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> DATA_MOUTH_ITEM = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> EATING_TIMER = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ACTIVELY_EATING = SynchedEntityData.m_135353_(OpossumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && itemEntity.m_32055_().m_150930_(Items.f_42780_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean aggressive = false;
    private boolean shouldSpawnBabies = false;
    private int deferredBabyCount = 0;
    private int babySpawnTimer = 0;

    public OpossumEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
        this.m_21153_(15.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static boolean canSpawn(EntityType<OpossumEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        if (!this.m_9236_().f_46443_ && !this.m_6162_()) {
            RandomSource random = world.m_213780_();
            int roll = random.m_188503_(100);
            int babyCount = roll < 25 ? 0 : (roll < 70 ? 1 : 2);
            this.setBabyCount(babyCount);
            if (babyCount > 0) {
                this.deferredBabyCount = babyCount;
                this.shouldSpawnBabies = true;
                this.babySpawnTimer = 5;
            }
        }
        return spawnData;
    }

    public void m_8119_() {
        int playDeadCooldown;
        int cooldown;
        super.m_8119_();
        if (this.m_6162_() && this.m_20159_()) {
            this.handleBabyPassengerSleep();
        }
        if (this.shouldSpawnBabies && !this.m_9236_().f_46443_) {
            if (this.babySpawnTimer > 0) {
                --this.babySpawnTimer;
            } else if (this.m_9236_() instanceof ServerLevel) {
                this.spawnBabies();
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_6162_() && (cooldown = this.getRidingCooldown()) > 0) {
            this.setRidingCooldown(cooldown - 1);
        }
        if (!this.m_9236_().f_46443_ && (playDeadCooldown = this.getPlayDeadCooldown()) > 0) {
            this.setPlayDeadCooldown(playDeadCooldown - 1);
        }
        if (!this.m_9236_().f_46443_) {
            for (Entity passenger : this.m_20197_()) {
                OpossumEntity babyOpossum;
                if (!(passenger instanceof OpossumEntity) || (babyOpossum = (OpossumEntity)passenger).m_6162_()) continue;
                passenger.m_8127_();
                babyOpossum.setHasRidden(false);
            }
        }
        this.handleEatingBerry();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(HAS_RIDDEN, (Object)false);
        this.f_19804_.m_135372_(BABY_COUNT, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(RIDING_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(PLAYING_DEAD, (Object)false);
        this.f_19804_.m_135372_(PLAY_DEAD_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(SHOULD_PLAY_DEAD, (Object)false);
        this.f_19804_.m_135372_(DATA_MOUTH_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(EATING_TIMER, (Object)0);
        this.f_19804_.m_135372_(IS_ACTIVELY_EATING, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Sleeping", this.m_5803_());
        tag.m_128379_("PlayingDead", this.isPlayingDead());
        tag.m_128379_("ShouldPlayDead", this.getShouldPlayDead());
        tag.m_128347_("PosX", this.m_20185_());
        tag.m_128347_("PosY", this.m_20186_());
        tag.m_128347_("PosZ", this.m_20189_());
        tag.m_128379_("ShouldSpawnBabies", this.shouldSpawnBabies);
        tag.m_128405_("DeferredBabyCount", this.deferredBabyCount);
        tag.m_128405_("BabySpawnTimer", this.babySpawnTimer);
        tag.m_128405_("RidingCooldown", this.getRidingCooldown());
        tag.m_128405_("PlayDeadCooldown", this.getPlayDeadCooldown());
        tag.m_128405_("EatingTimer", this.getEatingTimer());
        tag.m_128379_("ActivelyEating", this.isActivelyEating());
        ItemStack itemstack = this.getMouthItem();
        if (!itemstack.m_41619_()) {
            tag.m_128365_("MouthItem", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.setSleeping(tag.m_128471_("Sleeping"));
        boolean savedPlayingDead = tag.m_128471_("PlayingDead");
        if (savedPlayingDead && !this.m_9236_().f_46443_) {
            this.setPlayingDead(false);
            this.setPlayDeadCooldown(20);
        } else {
            this.setPlayingDead(savedPlayingDead);
        }
        this.setShouldPlayDead(tag.m_128471_("ShouldPlayDead"));
        if (tag.m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ")) {
            double posX = tag.m_128459_("PosX");
            double posY = tag.m_128459_("PosY");
            double posZ = tag.m_128459_("PosZ");
            this.m_6034_(posX, posY, posZ);
        }
        this.shouldSpawnBabies = tag.m_128471_("ShouldSpawnBabies");
        this.deferredBabyCount = tag.m_128451_("DeferredBabyCount");
        this.babySpawnTimer = tag.m_128451_("BabySpawnTimer");
        this.setRidingCooldown(tag.m_128451_("RidingCooldown"));
        this.setPlayDeadCooldown(tag.m_128451_("PlayDeadCooldown"));
        this.setEatingTimer(tag.m_128451_("EatingTimer"));
        this.setActivelyEating(tag.m_128471_("ActivelyEating"));
        if (tag.m_128425_("MouthItem", 10)) {
            this.setMouthItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("MouthItem")));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PlayDeadGoal());
        this.f_21345_.m_25352_(2, (Goal)new OpossumEatBerriesGoal(1.0, 16, 2));
        this.f_21345_.m_25352_(3, (Goal)new OpossumSearchForItemsGoal());
        this.f_21345_.m_25352_(4, (Goal)new FollowAdultOpossumGoal(this, 1.0, 2.0f, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_}), false));
        this.f_21345_.m_25352_(7, (Goal)new SleepGoal(200));
        this.f_21345_.m_25352_(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public boolean m_8036_() {
                return OpossumEntity.this.m_5912_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return OpossumEntity.this.m_5912_() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean m_8036_() {
                return !OpossumEntity.this.m_5803_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !OpossumEntity.this.m_5803_() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !OpossumEntity.this.m_5803_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !OpossumEntity.this.m_5803_() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                return OpossumEntity.this.m_5912_() && super.m_8036_();
            }
        });
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42780_ && !this.m_27593_() && this.m_146764_() == 0) {
            if (!this.m_9236_().f_46443_) {
                if (this.hasBabyPassengers()) {
                    this.dismountBabies();
                }
                this.m_27595_(player);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_27595_(@Nullable Player player) {
        if (this.hasBabyPassengers()) {
            this.dismountBabies();
        }
        super.m_27595_(player);
    }

    public OpossumEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        OpossumEntity babyOpossum = (OpossumEntity)((EntityType)FaunifyEntities.OPOSSUM.get()).m_20615_((Level)serverLevel);
        if (babyOpossum != null && otherParent instanceof OpossumEntity) {
            OpossumEntity parent = (OpossumEntity)otherParent;
            Variant selectedVariant = this.f_19796_.m_188499_() ? this.getVariant() : parent.getVariant();
            babyOpossum.setVariant(selectedVariant);
        }
        return babyOpossum;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42780_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (source.m_276093_(DamageTypes.f_268469_)) {
            return false;
        }
        if (this.m_5803_()) {
            this.setSleeping(false);
        }
        if (!this.m_9236_().f_46443_ && this.m_21223_() <= 8.0f && !this.isPlayingDead() && this.getPlayDeadCooldown() <= 0) {
            this.setShouldPlayDead(true);
        }
        if (!this.m_9236_().f_46443_) {
            this.dropMouthItem();
        }
        if (!this.m_6162_() && this.hasBabyPassengers()) {
            this.dismountBabies();
        }
        if (this.m_6162_() && this.m_20159_()) {
            Entity entity;
            Entity adult = this.m_20202_();
            this.m_8127_();
            this.setHasRidden(false);
            this.setRidingCooldown(100);
            if (this.m_21223_() <= 8.0f) {
                this.setPlayDeadCooldown(20);
                this.setShouldPlayDead(true);
            }
            if ((entity = source.m_7639_()) instanceof Player) {
                Player player = (Player)entity;
                if (adult instanceof OpossumEntity) {
                    OpossumEntity adultOpossum = (OpossumEntity)adult;
                    adultOpossum.m_6710_((LivingEntity)player);
                    adultOpossum.m_21561_(true);
                    this.m_5496_((SoundEvent)FaunifySounds.OPOSSUM_ANGRY.get(), 1.0f, 1.0f);
                }
            }
        }
        return result;
    }

    public boolean m_7327_(Entity target) {
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (target instanceof MouseEntity || target instanceof Rabbit) {
            return super.m_7327_(target);
        }
        return flag;
    }

    protected SoundEvent m_7515_() {
        int soundIndex = this.f_19796_.m_188503_(2);
        switch (soundIndex) {
            case 0: {
                return (SoundEvent)FaunifySounds.OPOSSUM_IDLE_1.get();
            }
            case 1: {
                return (SoundEvent)FaunifySounds.OPOSSUM_IDLE_2.get();
            }
        }
        return (SoundEvent)FaunifySounds.OPOSSUM_IDLE_1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.OPOSSUM_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<OpossumEntity> event) {
        LivingEntity target = this.m_5448_();
        Vec3 velocity = this.m_20184_();
        double horizontalSpeedSq = velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_;
        double movingThreshold = 0.001;
        if (target != null && !target.m_6084_()) {
            this.m_6710_(null);
            target = null;
        }
        if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isPlayingDead()) {
            event.getController().setAnimation(RawAnimation.begin().then("play_dead", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (horizontalSpeedSq > movingThreshold) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (horizontalSpeedSq > movingThreshold) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            return heldItem.m_41720_() == Items.f_42780_;
        }
        return false;
    }

    public boolean m_7310_(Entity passenger) {
        if (!(passenger instanceof OpossumEntity)) {
            return false;
        }
        OpossumEntity opossumPassenger = (OpossumEntity)passenger;
        return !this.m_6162_() && opossumPassenger.m_6162_() && this.m_20197_().size() < 2 && !this.isPlayingDead();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_7337_(Entity entity) {
        return entity != this && !this.m_20159_() && !entity.m_20159_();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        super.m_19956_(passenger, moveFunction);
        if (!(passenger instanceof OpossumEntity)) {
            return;
        }
        int currentBabyRiders = 0;
        for (Entity e : this.m_20197_()) {
            OpossumEntity opossum;
            if (!(e instanceof OpossumEntity) || !(opossum = (OpossumEntity)e).m_6162_()) continue;
            ++currentBabyRiders;
        }
        int index = this.m_20197_().indexOf(passenger);
        if (index == -1) {
            return;
        }
        double sideOffset = 0.0;
        if (currentBabyRiders == 2) {
            if (index == 0) {
                sideOffset = -0.15;
            } else if (index == 1) {
                sideOffset = 0.15;
            }
        } else {
            sideOffset = 0.0;
        }
        float yaw = this.m_146908_();
        double radians = Math.toRadians(yaw + 180.0f);
        double offsetX = Math.cos(radians) * sideOffset;
        double offsetZ = Math.sin(radians) * sideOffset;
        double yOffset = (double)this.m_20206_() * 0.8;
        passenger.m_6034_(this.m_20185_() + offsetX, this.m_20186_() + yOffset, this.m_20189_() + offsetZ);
    }

    public void m_146740_(int growthSeconds, boolean forced) {
        super.m_146740_(growthSeconds, forced);
        if (!this.m_6162_() && this.m_20159_()) {
            this.m_8127_();
            this.setHasRidden(false);
        }
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.canPickUpItem(itemstack)) {
            int itemCount = itemstack.m_41613_();
            if (!this.getMouthItem().m_41619_()) {
                this.dropMouthItem();
            }
            this.setMouthItem(new ItemStack((ItemLike)Items.f_42780_, 1));
            this.m_7938_((Entity)itemEntity, 1);
            if (itemCount > 1) {
                itemstack.m_41774_(1);
            } else {
                itemEntity.m_146870_();
            }
            this.m_5496_(SoundEvents.f_12019_, 0.2f, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public boolean canPickUpItem(ItemStack stack) {
        return stack.m_150930_(Items.f_42780_) && this.getMouthItem().m_41619_() && !this.isPlayingDead() && !this.m_5803_() && (!this.m_6162_() || !this.m_20159_());
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.f_19804_.m_135370_(PLAYING_DEAD);
    }

    public void setPlayingDead(boolean playingDead) {
        this.f_19804_.m_135381_(PLAYING_DEAD, (Object)playingDead);
    }

    public boolean getShouldPlayDead() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_PLAY_DEAD);
    }

    public void setShouldPlayDead(boolean shouldPlayDead) {
        this.f_19804_.m_135381_(SHOULD_PLAY_DEAD, (Object)shouldPlayDead);
    }

    public ItemStack getMouthItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_MOUTH_ITEM);
    }

    public void setMouthItem(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_MOUTH_ITEM, (Object)stack);
    }

    public int getEatingTimer() {
        return (Integer)this.f_19804_.m_135370_(EATING_TIMER);
    }

    public void setEatingTimer(int timer) {
        this.f_19804_.m_135381_(EATING_TIMER, (Object)timer);
    }

    public boolean isActivelyEating() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVELY_EATING);
    }

    public void setActivelyEating(boolean eating) {
        this.f_19804_.m_135381_(IS_ACTIVELY_EATING, (Object)eating);
    }

    public void setHasRidden(boolean value) {
        this.f_19804_.m_135381_(HAS_RIDDEN, (Object)value);
    }

    public boolean hasRidden() {
        return (Boolean)this.f_19804_.m_135370_(HAS_RIDDEN);
    }

    public void setBabyCount(int count) {
        this.f_19804_.m_135381_(BABY_COUNT, (Object)count);
    }

    public int getBabyCount() {
        return (Integer)this.f_19804_.m_135370_(BABY_COUNT);
    }

    public void m_21561_(boolean angry) {
        this.aggressive = angry;
    }

    public boolean m_5912_() {
        return this.aggressive;
    }

    public void setRidingCooldown(int ticks) {
        this.f_19804_.m_135381_(RIDING_COOLDOWN, (Object)ticks);
    }

    public int getRidingCooldown() {
        return (Integer)this.f_19804_.m_135370_(RIDING_COOLDOWN);
    }

    public boolean canRideAdult() {
        return this.getRidingCooldown() <= 0;
    }

    public void setPlayDeadCooldown(int ticks) {
        this.f_19804_.m_135381_(PLAY_DEAD_COOLDOWN, (Object)ticks);
    }

    public int getPlayDeadCooldown() {
        return (Integer)this.f_19804_.m_135370_(PLAY_DEAD_COOLDOWN);
    }

    void dropMouthItem() {
        if (!this.getMouthItem().m_41619_()) {
            this.m_19983_(this.getMouthItem());
            this.setMouthItem(ItemStack.f_41583_);
            this.setEatingTimer(0);
            this.setActivelyEating(false);
        }
    }

    public void dismountBabies() {
        if (!this.m_9236_().f_46443_) {
            OpossumEntity babyOpossum;
            ArrayList<Entity> passengersToRemove = new ArrayList<Entity>();
            for (Entity passenger : this.m_20197_()) {
                if (!(passenger instanceof OpossumEntity) || !(babyOpossum = (OpossumEntity)passenger).m_6162_()) continue;
                passengersToRemove.add(passenger);
            }
            for (Entity passenger : passengersToRemove) {
                passenger.m_8127_();
                if (!(passenger instanceof OpossumEntity)) continue;
                babyOpossum = (OpossumEntity)passenger;
                babyOpossum.setHasRidden(false);
                babyOpossum.setRidingCooldown(200);
            }
        }
    }

    public boolean hasBabyPassengers() {
        return this.m_20197_().stream().anyMatch(entity -> {
            OpossumEntity opossum;
            return entity instanceof OpossumEntity && (opossum = (OpossumEntity)((Object)entity)).m_6162_();
        });
    }

    private void spawnBabies() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int i = 0; i < this.deferredBabyCount; ++i) {
            OpossumEntity baby = (OpossumEntity)((EntityType)FaunifyEntities.OPOSSUM.get()).m_20615_(this.m_9236_());
            if (baby == null) continue;
            baby.m_6863_(true);
            baby.setVariant(this.getVariant());
            baby.m_6518_((ServerLevelAccessor)serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.NATURAL, null, null);
            baby.setVariant(this.getVariant());
            baby.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_9236_().m_7967_((Entity)baby);
            baby.m_7998_((Entity)this, true);
            baby.setHasRidden(true);
        }
        this.deferredBabyCount = 0;
        this.shouldSpawnBabies = false;
        this.babySpawnTimer = 0;
    }

    private void handleBabyPassengerSleep() {
        if (!this.m_9236_().f_46443_) {
            boolean shouldSleep = this.m_9236_().m_46462_();
            if (shouldSleep && !this.m_5803_()) {
                this.setSleeping(true);
            } else if (!shouldSleep && this.m_5803_()) {
                this.setSleeping(false);
            }
        }
    }

    private void handleEatingBerry() {
        if (!this.getMouthItem().m_41619_() && this.getMouthItem().m_150930_(Items.f_42780_)) {
            if (!this.m_9236_().f_46443_) {
                int currentTimer = this.getEatingTimer();
                if (currentTimer == 0) {
                    this.setEatingTimer(1320);
                    this.setActivelyEating(false);
                } else if (currentTimer > 0) {
                    this.setEatingTimer(currentTimer - 1);
                    if (currentTimer == 121) {
                        this.setActivelyEating(true);
                    }
                    if (currentTimer <= 120 && this.isActivelyEating() && currentTimer % 40 == 0) {
                        this.createEatingParticles();
                        this.m_5496_(SoundEvents.f_11912_, 0.8f, 1.0f);
                    }
                    if (currentTimer == 1) {
                        this.consumeBerry();
                    }
                }
            } else {
                int currentTimer = this.getEatingTimer();
                if (currentTimer > 0 && currentTimer <= 120 && this.isActivelyEating() && currentTimer % 40 == 0) {
                    this.createEatingParticles();
                }
            }
        } else if (this.getEatingTimer() > 0) {
            this.setEatingTimer(0);
            this.setActivelyEating(false);
        }
    }

    private void createEatingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack berryStack = new ItemStack((ItemLike)Items.f_42780_);
            ItemParticleOption particleData = new ItemParticleOption(ParticleTypes.f_123752_, berryStack);
            float yaw = this.m_146908_();
            double forwardX = -Math.sin(Math.toRadians(yaw)) * 0.6;
            double forwardZ = Math.cos(Math.toRadians(yaw)) * 0.6;
            Vec3 mouthPos = this.m_20182_().m_82520_(forwardX, (double)this.m_20206_() * 0.5, forwardZ);
            for (int i = 0; i < 3; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                serverLevel.m_8767_((ParticleOptions)particleData, mouthPos.f_82479_ + offsetX, mouthPos.f_82480_ + offsetY, mouthPos.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private void consumeBerry() {
        this.createEatingParticles();
        this.m_5496_(SoundEvents.f_11947_, 1.0f, 1.0f);
        this.setMouthItem(ItemStack.f_41583_);
        this.setEatingTimer(0);
        this.setActivelyEating(false);
        this.m_5634_(1.0f);
    }

    private void createStinkyParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float red = 0.4f;
            float green = 0.6f;
            float blue = 0.3f;
            DustParticleOptions dustOptions = new DustParticleOptions(new Vector3f(red, green, blue), 1.0f);
            for (int i = 0; i < 5; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                double offsetY = this.f_19796_.m_188500_() * 0.3 + 0.1;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                double velX = (this.f_19796_.m_188500_() - 0.5) * 0.02;
                double velY = this.f_19796_.m_188500_() * 0.05 + 0.02;
                double velZ = (this.f_19796_.m_188500_() - 0.5) * 0.02;
                serverLevel.m_8767_((ParticleOptions)dustOptions, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 1, velX, velY, velZ, 0.0);
            }
        }
    }

    public static enum Variant implements StringRepresentable
    {
        REGULAR(0, "regular"),
        LIGHT(1, "light"),
        DARK(2, "dark");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public class PlayDeadGoal
    extends Goal {
        private int playDeadTimer;
        private int particleTimer = 0;
        private static final int PLAY_DEAD_DURATION = 160;
        private static final int PLAY_DEAD_COOLDOWN_TIME = 100;
        private static final int PARTICLE_INTERVAL = 15;

        public PlayDeadGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (!OpossumEntity.this.getShouldPlayDead()) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead() || OpossumEntity.this.getPlayDeadCooldown() > 0) {
                return false;
            }
            if (OpossumEntity.this.m_5803_()) {
                return false;
            }
            return !OpossumEntity.this.m_6162_() || !OpossumEntity.this.m_20159_();
        }

        public boolean m_8045_() {
            if (OpossumEntity.this.m_6162_() && OpossumEntity.this.m_20159_()) {
                return false;
            }
            return this.playDeadTimer > 0 && OpossumEntity.this.isPlayingDead();
        }

        public void m_8056_() {
            this.playDeadTimer = 160;
            this.particleTimer = 0;
            OpossumEntity.this.setPlayingDead(true);
            OpossumEntity.this.setShouldPlayDead(false);
            OpossumEntity.this.m_21573_().m_26573_();
            OpossumEntity.this.m_20256_(Vec3.f_82478_);
            if (!OpossumEntity.this.m_6162_() && OpossumEntity.this.hasBabyPassengers()) {
                OpossumEntity.this.dismountBabies();
            }
            OpossumEntity.this.m_6710_(null);
            OpossumEntity.this.m_21561_(false);
        }

        public void m_8041_() {
            OpossumEntity.this.setPlayingDead(false);
            OpossumEntity.this.setPlayDeadCooldown(100);
            this.playDeadTimer = 0;
            this.particleTimer = 0;
        }

        public void m_8037_() {
            if (OpossumEntity.this.m_6162_() && OpossumEntity.this.m_20159_()) {
                OpossumEntity.this.setPlayingDead(false);
                return;
            }
            if (this.playDeadTimer > 0) {
                --this.playDeadTimer;
                OpossumEntity.this.m_21573_().m_26573_();
                OpossumEntity.this.m_20256_(Vec3.f_82478_);
                OpossumEntity.this.f_20900_ = 0.0f;
                OpossumEntity.this.f_20901_ = 0.0f;
                OpossumEntity.this.f_20902_ = 0.0f;
                ++this.particleTimer;
                if (this.particleTimer >= 15) {
                    this.particleTimer = 0;
                    OpossumEntity.this.createStinkyParticles();
                }
            }
            if (this.playDeadTimer <= 0 && OpossumEntity.this.isPlayingDead()) {
                OpossumEntity.this.setPlayingDead(false);
            }
        }
    }

    public class OpossumEatBerriesGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public OpossumEatBerriesGoal(double speedModifier, int searchRange, int verticalSearchRange) {
            super((PathfinderMob)OpossumEntity.this, speedModifier, searchRange, verticalSearchRange);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockState blockstate = level.m_8055_(pos);
            return blockstate.m_60713_(Blocks.f_50685_) && (Integer)blockstate.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 2;
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.m_25625_() && OpossumEntity.this.m_217043_().m_188501_() < 0.05f) {
                OpossumEntity.this.m_5496_(SoundEvents.f_11951_, 1.0f, 1.0f);
            }
            super.m_8037_();
        }

        protected void onReachedTarget() {
            if (ForgeHooks.onCropsGrowPre((Level)OpossumEntity.this.m_9236_(), (BlockPos)this.f_25602_, (BlockState)OpossumEntity.this.m_9236_().m_8055_(this.f_25602_), (boolean)true)) {
                BlockState blockstate = OpossumEntity.this.m_9236_().m_8055_(this.f_25602_);
                if (blockstate.m_60713_(Blocks.f_50685_)) {
                    this.pickSweetBerries(blockstate);
                }
                ForgeHooks.onCropsGrowPost((Level)OpossumEntity.this.m_9236_(), (BlockPos)this.f_25602_, (BlockState)OpossumEntity.this.m_9236_().m_8055_(this.f_25602_));
            }
        }

        private void pickSweetBerries(BlockState state) {
            int currentAge = (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            int berriesToDrop = 1 + OpossumEntity.this.m_9236_().f_46441_.m_188503_(2) + (currentAge == 3 ? 1 : 0);
            ItemStack mouthItem = OpossumEntity.this.getMouthItem();
            if (mouthItem.m_41619_()) {
                OpossumEntity.this.setMouthItem(new ItemStack((ItemLike)Items.f_42780_));
            }
            if (berriesToDrop > 0) {
                Block.m_49840_((Level)OpossumEntity.this.m_9236_(), (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, berriesToDrop));
            }
            OpossumEntity.this.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
            OpossumEntity.this.m_9236_().m_7731_(this.f_25602_, (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
        }

        public boolean m_8036_() {
            return !OpossumEntity.this.m_5803_() && !OpossumEntity.this.isPlayingDead() && (!OpossumEntity.this.m_6162_() || !OpossumEntity.this.m_20159_()) && super.m_8036_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }
    }

    public class OpossumSearchForItemsGoal
    extends Goal {
        public OpossumSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!OpossumEntity.this.getMouthItem().m_41619_()) {
                return false;
            }
            if (OpossumEntity.this.m_5448_() != null || OpossumEntity.this.m_21188_() != null) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead() || OpossumEntity.this.m_5803_()) {
                return false;
            }
            if (OpossumEntity.this.m_6162_() && OpossumEntity.this.m_20159_()) {
                return false;
            }
            if (OpossumEntity.this.m_217043_().m_188503_(OpossumSearchForItemsGoal.m_186073_((int)10)) != 0) {
                return false;
            }
            List list = OpossumEntity.this.m_9236_().m_6443_(ItemEntity.class, OpossumEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !list.isEmpty();
        }

        public void m_8037_() {
            List list = OpossumEntity.this.m_9236_().m_6443_(ItemEntity.class, OpossumEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (OpossumEntity.this.getMouthItem().m_41619_() && !list.isEmpty()) {
                ItemEntity closest = (ItemEntity)list.get(0);
                double closestDistance = OpossumEntity.this.m_20280_((Entity)closest);
                for (ItemEntity item : list) {
                    double distance = OpossumEntity.this.m_20280_((Entity)item);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closest = item;
                }
                if (closestDistance <= 2.25) {
                    OpossumEntity.this.m_7581_(closest);
                } else {
                    OpossumEntity.this.m_21573_().m_26519_(closest.m_20185_(), closest.m_20186_(), closest.m_20189_(), 1.2);
                }
            }
        }

        public void m_8056_() {
            List list = OpossumEntity.this.m_9236_().m_6443_(ItemEntity.class, OpossumEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                ItemEntity target = (ItemEntity)list.get(0);
                OpossumEntity.this.m_21573_().m_26519_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.2);
            }
        }
    }

    public class FollowAdultOpossumGoal
    extends Goal {
        private final OpossumEntity baby;
        private OpossumEntity targetAdult;
        private final double speedModifier;
        private final float stopDistance;
        private final float startDistance;
        private int timeToRecalcPath;

        public FollowAdultOpossumGoal(OpossumEntity baby, double speedModifier, float stopDistance, float startDistance) {
            this.baby = baby;
            this.speedModifier = speedModifier;
            this.stopDistance = stopDistance;
            this.startDistance = startDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.baby.m_6162_()) {
                return false;
            }
            if (this.baby.m_20159_()) {
                return false;
            }
            if (this.baby.m_5803_()) {
                return false;
            }
            OpossumEntity nearestAdult = this.findNearestAdult();
            if (nearestAdult == null) {
                return false;
            }
            double distance = this.baby.m_20270_((Entity)nearestAdult);
            if (distance < (double)this.startDistance) {
                this.targetAdult = nearestAdult;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.targetAdult == null || !this.targetAdult.m_6084_() || !this.baby.m_6162_()) {
                return false;
            }
            if (this.baby.m_20159_()) {
                return false;
            }
            if (this.baby.m_5803_()) {
                return false;
            }
            double distance = this.baby.m_20270_((Entity)this.targetAdult);
            return distance < (double)this.startDistance * 1.5;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.targetAdult = null;
            this.baby.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.targetAdult == null) {
                return;
            }
            if (this.baby.m_5803_()) {
                this.baby.m_21573_().m_26573_();
                return;
            }
            this.baby.m_21563_().m_148051_((Entity)this.targetAdult);
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                double distance = this.baby.m_20270_((Entity)this.targetAdult);
                if (distance <= 2.5 && this.targetAdult.m_7310_((Entity)this.baby) && this.baby.canRideAdult() && !this.targetAdult.isPlayingDead()) {
                    this.baby.m_7998_((Entity)this.targetAdult, true);
                    this.baby.setHasRidden(true);
                    return;
                }
                if (distance > (double)this.stopDistance) {
                    this.baby.m_21573_().m_5624_((Entity)this.targetAdult, this.speedModifier);
                } else {
                    this.baby.m_21573_().m_26573_();
                }
            }
        }

        private OpossumEntity findNearestAdult() {
            double closestDistance = Double.MAX_VALUE;
            OpossumEntity closestAdult = null;
            for (Entity entity : this.baby.m_9236_().m_45976_(OpossumEntity.class, this.baby.m_20191_().m_82400_((double)this.startDistance))) {
                double distance;
                OpossumEntity opossum;
                if (!(entity instanceof OpossumEntity) || (opossum = (OpossumEntity)entity).m_6162_() || opossum == this.baby || !opossum.m_6084_() || !((distance = (double)this.baby.m_20270_((Entity)opossum)) < closestDistance)) continue;
                closestDistance = distance;
                closestAdult = opossum;
            }
            return closestAdult;
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = OpossumEntity.this.f_19796_.m_188503_(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            boolean isStationary;
            if (OpossumEntity.this.m_20069_()) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead()) {
                return false;
            }
            if (OpossumEntity.this.m_6162_() && OpossumEntity.this.m_20159_()) {
                return false;
            }
            if (OpossumEntity.this.hasBabyPassengers()) {
                return false;
            }
            if (OpossumEntity.this.m_5803_()) {
                return true;
            }
            boolean bl = isStationary = OpossumEntity.this.f_20900_ == 0.0f && OpossumEntity.this.f_20901_ == 0.0f && OpossumEntity.this.f_20902_ == 0.0f;
            if (isStationary) {
                return this.canSleep();
            }
            return false;
        }

        public boolean m_8045_() {
            if (OpossumEntity.this.m_20069_()) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead()) {
                return false;
            }
            if (OpossumEntity.this.m_6162_() && OpossumEntity.this.m_20159_()) {
                return false;
            }
            if (OpossumEntity.this.hasBabyPassengers()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return OpossumEntity.this.m_9236_().m_46462_();
        }

        public void m_8041_() {
            if (!OpossumEntity.this.m_6162_() || !OpossumEntity.this.m_20159_()) {
                OpossumEntity.this.setSleeping(false);
            }
            this.countdown = OpossumEntity.this.f_19796_.m_188503_(this.countdownTime);
        }

        public void m_8056_() {
            if (!OpossumEntity.this.m_6162_() || !OpossumEntity.this.m_20159_()) {
                OpossumEntity.this.m_6862_(false);
                OpossumEntity.this.setSleeping(true);
                OpossumEntity.this.m_21573_().m_26573_();
            }
        }

        public void m_8037_() {
            if (OpossumEntity.this.m_6162_() && OpossumEntity.this.m_20159_()) {
                return;
            }
            if (!OpossumEntity.this.m_6162_() && OpossumEntity.this.hasBabyPassengers()) {
                OpossumEntity.this.setSleeping(false);
                return;
            }
            if (OpossumEntity.this.m_5803_()) {
                OpossumEntity.this.m_21573_().m_26573_();
            }
        }
    }
}

