/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.BasePetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.EnderBullet;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;

public class EndIslandsEnderman
extends BaseEnderman {
    private static final EntityDataAccessor<Boolean> DATA_POSSESSING = SynchedEntityData.m_135353_(EndIslandsEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EndIslandsEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 42;
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.21).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnEndIslandsEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        if (random.m_188503_(5) != 0) {
            return false;
        }
        return BaseEnderman.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "possessing_controller", 5, state -> {
            if (!((Boolean)this.f_19804_.m_135370_(DATA_POSSESSING)).booleanValue()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.POSSESS);
            return PlayState.CONTINUE;
        })});
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new EndIslandsEndermanSummonProjectileGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_POSSESSING, (Object)false);
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    public boolean canShake() {
        return false;
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    public boolean isAlwaysHostile() {
        return true;
    }

    @Override
    public boolean canTeleport() {
        return false;
    }

    @Override
    public double getVisionRange() {
        return 32.0;
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public boolean speedUpWhenAngry() {
        return false;
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.m_5448_() != null) {
            this.spawnProjectiles((Entity)this.m_5448_());
        }
    }

    public void spawnProjectiles(Entity target) {
        for (int i = 0; i < 3; ++i) {
            EnderBullet bullet = new EnderBullet(this.m_9236_(), (LivingEntity)this, target, this.m_6350_().m_122434_());
            bullet.m_6034_(this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0, this.m_20186_() + 1.0 + (this.f_19796_.m_188500_() - 0.5) * 2.0, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0);
            this.m_9236_().m_7967_((Entity)bullet);
        }
    }

    public boolean isPossessing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_POSSESSING);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_DEATH.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_DEATH.get();
    }

    @Override
    public SoundEvent getStareSound() {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_STARE.get();
    }

    public class EndIslandsEndermanSummonProjectileGoal
    extends Goal {
        protected int summonTicks;
        protected int nextAttackTickCount = 400;

        public boolean m_8036_() {
            LivingEntity target = EndIslandsEnderman.this.m_5448_();
            if (target != null && target.m_6084_()) {
                if (EndIslandsEnderman.this.isPossessing()) {
                    if (EndIslandsEnderman.this.f_19797_ + 500 >= this.nextAttackTickCount) {
                        EndIslandsEnderman.this.f_19804_.m_135381_(DATA_POSSESSING, (Object)false);
                        return true;
                    }
                    return false;
                }
                return EndIslandsEnderman.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity target = EndIslandsEnderman.this.m_5448_();
            return target != null && target.m_6084_() && this.summonTicks > 0;
        }

        public void m_8056_() {
            EndIslandsEnderman.this.f_19804_.m_135381_(DATA_POSSESSING, (Object)true);
            this.nextAttackTickCount = EndIslandsEnderman.this.f_19797_ + 400;
            this.summonTicks = 28;
        }

        public void m_8041_() {
            super.m_8041_();
            LivingEntity target = EndIslandsEnderman.this.m_5448_();
            if (target == null) {
                return;
            }
            EndIslandsEnderman.this.f_19804_.m_135381_(DATA_POSSESSING, (Object)false);
            EndIslandsEnderman.this.m_9236_().m_45933_((Entity)EndIslandsEnderman.this, EndIslandsEnderman.this.m_20191_().m_82400_(15.0)).stream().filter(entity -> entity instanceof EnderMan).filter(entity -> !(entity instanceof BasePetEnderman)).forEach(entity -> ((EnderMan)entity).m_6710_(target));
            EndIslandsEnderman.this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
            EndIslandsEnderman.this.spawnProjectiles((Entity)target);
            EndIslandsEnderman.this.m_5496_(SoundEvents.f_11862_, 1.0f, 1.0f);
        }

        public void m_8037_() {
            --this.summonTicks;
            EndIslandsEnderman.this.f_21344_.m_26573_();
        }
    }
}

