/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EmiFireworkStarRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::m_41082_).toList();
    private static final List<Item> SHAPES = List.of(Items.f_42613_, Items.f_42402_, Items.f_42587_, Items.f_42678_, Items.f_42679_, Items.f_42682_, Items.f_42680_, Items.f_42683_, Items.f_42681_);
    private static final List<Item> EFFECTS = List.of(Items.f_42415_, Items.f_42525_);

    public EmiFireworkStarRecipe(ResourceLocation id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList())), EmiIngredient.of(SHAPES.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList())), EmiIngredient.of(EFFECTS.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList())), EmiStack.of((ItemLike)Items.f_42403_)), EmiStack.of((ItemLike)Items.f_42689_), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of((ItemLike)Items.f_42403_), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<Item> items = this.getItems((Random)r);
            if (s < items.size()) {
                return EmiStack.of((ItemLike)items.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getFireworkStar, this.unique, x, y);
    }

    private List<DyeItem> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private List<Item> getItems(Random random) {
        ArrayList items = Lists.newArrayList();
        int amount = random.nextInt(4);
        if (amount < 2) {
            items.add(EFFECTS.get(amount));
        } else if (amount == 2) {
            items.add(EFFECTS.get(0));
            items.add(EFFECTS.get(1));
        }
        amount = random.nextInt(10);
        if (amount < 9) {
            items.add(SHAPES.get(amount));
        }
        items.addAll(this.getDyes(random, 8 - items.size()));
        return items;
    }

    private EmiStack getFireworkStar(Random random) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag tag = new CompoundTag();
        CompoundTag explosion = new CompoundTag();
        boolean hasShape = false;
        List<Item> items = this.getItems(random);
        byte smallBall = 0;
        byte largeBall = 1;
        byte star = 2;
        byte creeper = 3;
        byte burst = 4;
        ArrayList colors = Lists.newArrayList();
        for (Item item : items) {
            if (Items.f_42525_.equals(item)) {
                explosion.m_128344_("Flicker", largeBall);
                continue;
            }
            if (Items.f_42415_.equals(item)) {
                explosion.m_128344_("Trail", largeBall);
                continue;
            }
            if (Items.f_42613_.equals(item)) {
                explosion.m_128344_("Type", largeBall);
                hasShape = true;
                continue;
            }
            if (Items.f_42587_.equals(item)) {
                explosion.m_128344_("Type", star);
                hasShape = true;
                continue;
            }
            if (Items.f_42402_.equals(item)) {
                explosion.m_128344_("Type", burst);
                hasShape = true;
                continue;
            }
            if (SHAPES.contains(item)) {
                explosion.m_128344_("Type", creeper);
                hasShape = true;
                continue;
            }
            DyeItem dyeItem = (DyeItem)item;
            colors.add(dyeItem.m_41089_().m_41070_());
        }
        if (!hasShape) {
            explosion.m_128344_("Type", smallBall);
        }
        explosion.m_128408_("Colors", (List)colors);
        tag.m_128365_("Explosion", (Tag)explosion);
        stack.m_41751_(tag);
        return EmiStack.of(stack);
    }
}

