/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot;

import com.google.common.collect.Maps;
import com.illusivesoulworks.elytraslot.ElytraSlotCommonMod;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class ElytraSlotArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;

    public ElytraSlotArmorLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet modelSet, boolean slim) {
        super(pRenderer);
        this.innerModel = slim ? new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171167_)) : new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171164_));
        this.outerModel = slim ? new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171168_)) : new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171165_));
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ElytraSlotCommonMod.getElytraRender(pLivingEntity).ifPresent(elytra -> {
            ItemStack stack = elytra.stack();
            Item patt3116$temp = elytra.stack().m_41720_();
            if (patt3116$temp instanceof ArmorItem) {
                ArmorItem armoritem = (ArmorItem)patt3116$temp;
                EquipmentSlot slot = EquipmentSlot.CHEST;
                if (armoritem.m_40402_() == slot) {
                    A originalModel = this.getArmorModel(slot);
                    ((HumanoidModel)this.m_117386_()).m_102872_(originalModel);
                    this.setPartVisibility(originalModel, slot);
                    Model model = this.getArmorModelHook(pLivingEntity, elytra.stack(), slot, originalModel);
                    boolean flag1 = stack.m_41790_();
                    if (armoritem instanceof DyeableLeatherItem) {
                        int i = ((DyeableLeatherItem)armoritem).m_41121_(stack);
                        float f = (float)(i >> 16 & 0xFF) / 255.0f;
                        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                        float f2 = (float)(i & 0xFF) / 255.0f;
                        this.renderModel(pMatrixStack, pBuffer, pPackedLight, flag1, model, f, f1, f2, this.getArmorResource((Entity)pLivingEntity, stack, slot, null));
                        this.renderModel(pMatrixStack, pBuffer, pPackedLight, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, stack, slot, "overlay"));
                    } else {
                        this.renderModel(pMatrixStack, pBuffer, pPackedLight, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, stack, slot, null));
                    }
                }
            }
        });
    }

    protected void setPartVisibility(A pModel, EquipmentSlot pSlot) {
        pModel.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                ((HumanoidModel)pModel).f_102808_.f_104207_ = true;
                ((HumanoidModel)pModel).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)pModel).f_102810_.f_104207_ = true;
                ((HumanoidModel)pModel).f_102811_.f_104207_ = true;
                ((HumanoidModel)pModel).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)pModel).f_102810_.f_104207_ = true;
                ((HumanoidModel)pModel).f_102813_.f_104207_ = true;
                ((HumanoidModel)pModel).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)pModel).f_102813_.f_104207_ = true;
                ((HumanoidModel)pModel).f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack pPoseStack, MultiBufferSource pBuffer, int p_117109_, boolean p_117111_, Model pModel, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)pBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        pModel.m_7695_(pPoseStack, vertexconsumer, p_117109_, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    private A getArmorModel(EquipmentSlot pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.LEGS;
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        return ForgeHooksClient.getArmorModel(entity, (ItemStack)itemStack, (EquipmentSlot)slot, model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

