/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.item;

import com.eeeab.animate.server.animation.EMAnimatedEntity;
import com.eeeab.animate.server.inventory.AnimationControllerMenu;
import com.eeeab.eeeabsmobs.sever.item.util.EMItemStackUtils;
import com.eeeab.eeeabsmobs.sever.util.EMTUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemAnimationController
extends Item {
    private static final String NBT_ENTITY_UUID = "animationEntityUUID";

    public ItemAnimationController() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof EMAnimatedEntity) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_(NBT_ENTITY_UUID, entity.m_20148_());
            EMItemStackUtils.putNBT(stack, NBT_ENTITY_UUID, tag);
            if (player.m_9236_().f_46443_) {
                player.m_5661_(EMTUtils.simpleOtherText(this.m_5524_(), null, entity.m_7755_().getString()), true);
            }
        }
        return true;
    }

    public boolean m_5812_(ItemStack stack) {
        return EMItemStackUtils.hasNBT(stack, NBT_ENTITY_UUID) || super.m_5812_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add(EMTUtils.simpleItemText(this.m_5524_(), new Object[0]));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (itemStack.m_41782_()) {
                Entity entity = serverLevel.m_8791_(EMItemStackUtils.getNBT(itemStack, NBT_ENTITY_UUID).m_128342_(NBT_ENTITY_UUID));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (entity instanceof LivingEntity) {
                        final LivingEntity livingEntity = (LivingEntity)entity;
                        if (entity instanceof EMAnimatedEntity && entity.m_6084_()) {
                            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                                @NotNull
                                public Component m_5446_() {
                                    return livingEntity.m_7755_();
                                }

                                @NotNull
                                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                                    return new AnimationControllerMenu(containerId, playerInventory, (Entity)livingEntity);
                                }
                            }, buf -> buf.writeInt(livingEntity.m_19879_()));
                        }
                    }
                }
                if (entity == null || !entity.m_6084_()) {
                    EMItemStackUtils.removeNbt(itemStack, NBT_ENTITY_UUID);
                    return InteractionResultHolder.m_19100_((Object)itemStack);
                }
                player.m_36335_().m_41524_((Item)this, 20);
            }
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }
}

