/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.entity.LivingEntity;

public interface CrackinessEntity<T extends LivingEntity> {
    default public CrackinessType getCrackiness(T entity) {
        return CrackinessType.byFraction(entity.m_21223_() / entity.m_21233_());
    }

    public static enum CrackinessType {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<CrackinessType> BY_DAMAGE;
        private final float fraction;

        private CrackinessType(float pFraction) {
            this.fraction = pFraction;
        }

        public static CrackinessType byFraction(float pFraction) {
            for (CrackinessType crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(CrackinessType.values()).sorted(Comparator.comparingDouble(crackiness -> crackiness.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

