/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangeModelVisibilityMessage(UUID uuid, ModelPart modelPart, boolean visible) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_model_visibility");

    public static ChangeModelVisibilityMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelVisibilityMessage(buffer.m_130259_(), (ModelPart)buffer.m_130066_(ModelPart.class), buffer.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.modelPart);
        buffer.writeBoolean(this.visible);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPart == null) {
            log.error("Invalid modelPart for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} visibility to {} for {} from {}", (Object)this.modelPart, (Object)this.visible, easyNPC, (Object)serverPlayer);
        if (this.modelPart != ModelPart.ROOT) {
            easyNPC.getEntity().m_20124_(Pose.STANDING);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartVisible(this.modelPart, this.visible);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
        }
    }
}

