/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface RenderData<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final String DATA_RENDER_DATA_TAG = "RenderData";

    public static void registerSyncedRenderData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Render Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.RENDER_DATA, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.RENDER_DATA_SET));
    }

    default public void defineSynchedRenderData() {
        this.defineSynchedEntityData(SynchedDataIndex.RENDER_DATA, new RenderDataSet());
    }

    default public RenderDataSet getRenderDataSet() {
        return (RenderDataSet)this.getSynchedEntityData(SynchedDataIndex.RENDER_DATA);
    }

    default public void setRenderData(RenderDataSet renderData) {
        this.setSynchedEntityData(SynchedDataIndex.RENDER_DATA, renderData);
    }

    default public void updateRenderData() {
        RenderDataSet renderDataSet = this.getRenderDataSet();
        this.setRenderData(new RenderDataSet());
        this.setRenderData(renderDataSet);
    }

    default public void addAdditionalRenderData(CompoundTag compoundTag) {
        CompoundTag renderTag = new CompoundTag();
        RenderDataSet renderData = this.getRenderDataSet();
        if (renderData != null) {
            renderData.save(renderTag);
        }
        compoundTag.m_128365_(DATA_RENDER_DATA_TAG, (Tag)renderTag);
    }

    default public void readAdditionalRenderData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_RENDER_DATA_TAG)) {
            return;
        }
        RenderDataSet renderData = new RenderDataSet(compoundTag.m_128469_(DATA_RENDER_DATA_TAG));
        this.setRenderData(renderData);
    }
}

