/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;

public class JsonContainer {
    public Entry[] models;
    public Entry[] bounding_boxes;
    public transient JsonContainer entries;

    public JsonContainer(String path) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try (FileReader reader = new FileReader(path);){
            this.entries = (JsonContainer)gson.fromJson((Reader)reader, JsonContainer.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsonContainer(InputStream path) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        this.entries = (JsonContainer)gson.fromJson((Reader)new InputStreamReader(path), JsonContainer.class);
    }

    public static class Entry {
        public String name;
        public String model;
        public String material;
        public String shape;
        public String type;
        public float scale;
        public boolean hidden;
        public String tabs;
        public boolean transparency;
        public boolean passable;
        public boolean culling = true;
        public String default_animation = "idle";
        public Script script = new Script();
        public FlipBook flipbook = new FlipBook();
        public float[] crafting_color = new float[]{-1.0f, -1.0f, -1.0f};

        public Entry() {
        }

        public Entry(Entry o) {
            this.name = o.name;
            this.model = o.model;
            this.material = o.material;
            this.shape = o.shape;
            this.type = o.type;
            this.scale = o.scale;
            this.hidden = o.hidden;
            this.tabs = o.tabs;
            this.transparency = o.transparency;
            this.passable = o.passable;
            this.culling = o.culling;
            this.default_animation = o.default_animation;
            this.script = o.script != null ? new Script(o.script) : new Script();
            this.flipbook = o.flipbook != null ? new FlipBook(o.flipbook) : new FlipBook();
            this.crafting_color = o.crafting_color;
        }

        public String toString() {
            return String.format("<Meta: %s | model: %s | material: %s>", this.name, this.model, this.material);
        }
    }

    public static class Particle {
        public String name;
        public float vx = 0.0f;
        public float vy = 0.0f;
        public float vz = 0.0f;
        public int delay = 0;
        public float size = 1.0f;

        public Particle() {
        }

        public Particle(Particle o) {
            this.name = o.name;
            this.vx = o.vx;
            this.vy = o.vy;
            this.vz = o.vz;
            this.delay = o.delay;
            this.size = o.size;
        }
    }

    public static class FlipBook {
        public int frametime = -1;
        public int images = 1;

        public FlipBook() {
        }

        public FlipBook(FlipBook o) {
            this.frametime = o.frametime;
            this.images = o.images;
        }
    }

    public static class Script {
        public Action on_use;
        public Action shift_on_use;
        public Action added;
        public Action removed;
        public Action trigger;
        public Action animation_start;
        public Action animation_end;
        public int counter = -1;
        public int light = 1;
        public HashMap<String, Particle> particles;

        public Script() {
        }

        public Script(Script o) {
            this.on_use = o.on_use != null ? new Action(o.on_use) : null;
            this.shift_on_use = o.shift_on_use != null ? new Action(o.shift_on_use) : null;
            this.added = o.added != null ? new Action(o.added) : null;
            this.removed = o.removed != null ? new Action(o.removed) : null;
            this.trigger = o.trigger != null ? new Action(o.trigger) : null;
            this.animation_start = o.animation_start != null ? new Action(o.animation_start) : null;
            this.animation_end = o.animation_end != null ? new Action(o.animation_end) : null;
            this.counter = o.counter;
            this.light = o.light;
            this.particles = o.particles;
        }
    }

    public static class Animation {
        public String to;
        public String from;

        public Animation() {
        }

        public Animation(Animation o) {
            this.to = o.to;
            this.from = o.from;
        }
    }

    public static class Action {
        public String link;
        public String sound;
        public List<Animation> animations;

        public Action() {
        }

        public Action(Action o) {
            this.link = o.link;
            this.sound = o.sound;
            this.animations = o.animations;
        }
    }
}

