/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.ponder;

import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAFluids;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.util.CALang;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PonderScenes {
    public static void electricMotor(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("electric_motor", CALang.translateDirect("ponder.electric_motor.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos motor = util.grid().at(3, 1, 2);
        for (int i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(1 + i, 1, 2), Direction.DOWN);
        }
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(motor);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.electric_motor.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(motor));
        scene.idle(50);
        scene.rotateCameraY(90.0f);
        scene.idle(20);
        Vec3 blockSurface = util.vector().blockSurface(motor, Direction.EAST);
        AABB point = new AABB(blockSurface, blockSurface);
        AABB expanded = point.m_82377_(0.0625, (double)0.2f, (double)0.2f);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, (Object)blockSurface, point, 1);
        scene.idle(1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, (Object)blockSurface, expanded, 60);
        scene.overlay().showControls(blockSurface, Pointing.DOWN, 60).scroll();
        scene.idle(20);
        scene.addKeyframe();
        scene.overlay().showText(70).text(CALang.translateDirect("ponder.electric_motor.text_2", new Object[0]).getString()).placeNearTarget().pointAt(blockSurface);
        scene.idle(10);
        scene.world().modifyKineticSpeed(util.select().fromTo(1, 1, 2, 3, 1, 2), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.effects().rotationSpeedIndicator(motor);
        scene.idle(70);
        scene.addKeyframe();
        scene.overlay().showText(70).text(CALang.translateDirect("ponder.electric_motor.text_3", new Object[0]).getString()).placeNearTarget().pointAt(blockSurface);
        scene.idle(80);
        scene.overlay().showText(70).text(CALang.translateDirect("ponder.electric_motor.text_4", new Object[0]).getString()).placeNearTarget().pointAt(blockSurface);
        scene.idle(80);
        scene.markAsFinished();
        scene.rotateCameraY(-90.0f);
    }

    public static void alternator(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("alternator", CALang.translateDirect("ponder.alternator.header", new Object[0]).getString());
        scene.configureBasePlate(1, 0, 4);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos generator = util.grid().at(3, 1, 2);
        for (int i = 0; i < 6; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(i, 1, 2), Direction.DOWN);
        }
        scene.idle(10);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.alternator.text_2", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(generator));
        scene.idle(60);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.alternator.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(generator));
        scene.idle(60);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.alternator.text_3", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(generator));
        scene.idle(60);
        scene.markAsFinished();
    }

    public static void rollingMill(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("rolling_mill", CALang.translateDirect("ponder.rolling_mill.header", new Object[0]).getString());
        scene.configureBasePlate(1, 0, 4);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos mill = util.grid().at(3, 1, 2);
        for (int i = 0; i < 6; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(i, 1, 2), Direction.DOWN);
        }
        scene.idle(10);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.rolling_mill.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(mill));
        scene.idle(60);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.rolling_mill.text_2", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(mill));
        scene.idle(60);
        scene.addKeyframe();
        scene.overlay().showControls(util.vector().topOf(mill), Pointing.DOWN, 50).rightClick();
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.rolling_mill.text_3", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(mill));
        scene.idle(60);
        scene.markAsFinished();
    }

    public static void automateRollingMill(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("automated_rolling_mill", CALang.translateDirect("ponder.automated_rolling_mill.header", new Object[0]).getString());
        scene.configureBasePlate(1, 0, 4);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos mill = util.grid().at(3, 2, 2);
        BlockPos in = util.grid().at(3, 2, 3);
        BlockPos out = util.grid().at(3, 2, 1);
        for (i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(i, 1, 4), Direction.DOWN);
        }
        for (i = 5; i >= 0; --i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(3, 1, i), Direction.DOWN);
            scene.world().showSection(util.select().position(4, 1, i), Direction.DOWN);
            scene.world().showSection(util.select().position(4, 2, i), Direction.DOWN);
        }
        scene.world().showSection(util.select().position(mill), Direction.DOWN);
        scene.addKeyframe();
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.automated_rolling_mill.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(mill));
        scene.idle(60);
        scene.idle(5);
        scene.world().showSection(util.select().position(in), Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(out), Direction.SOUTH);
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void ccMotor(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cc_electric_motor", CALang.translateDirect("ponder.cc_electric_motor.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos motor = util.grid().at(2, 1, 2);
        BlockPos computer = util.grid().at(1, 1, 2);
        scene.idle(5);
        scene.world().showSection(util.select().position(motor), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(computer), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.cc_electric_motor.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(computer));
        scene.idle(60);
        scene.idle(10);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.cc_electric_motor.text_2", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(computer));
        scene.idle(60);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay().showText(150).text(CALang.translateDirect("ponder.cc_electric_motor.text_3", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(computer));
        scene.idle(160);
        scene.markAsFinished();
    }

    public static void teslaCoil(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("tesla_coil", CALang.translateDirect("ponder.tesla_coil.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().setBlock(util.grid().at(3, 2, 2), Blocks.f_49990_.m_49966_(), false);
        BlockPos depotPos = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().position(2, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 3, 2), Direction.DOWN);
        scene.idle(5);
        Vec3 topOf = util.vector().topOf(depotPos);
        scene.overlay().showText(50).attachKeyFrame().text(CALang.translateDirect("ponder.tesla_coil.text_1", new Object[0]).getString()).placeNearTarget().pointAt(topOf);
        scene.idle(60);
        scene.world().createItemOnBeltLike(depotPos, Direction.NORTH, AllItems.CHROMATIC_COMPOUND.asStack());
        scene.idle(10);
        scene.world().setBlock(util.grid().at(2, 3, 2), (BlockState)((BlockState)CABlocks.TESLA_COIL.getDefaultState().m_61124_((Property)TeslaCoilBlock.FACING, (Comparable)Direction.UP)).m_61124_((Property)TeslaCoilBlock.POWERED, (Comparable)Boolean.valueOf(true)), false);
        scene.overlay().showText(70).attachKeyFrame().text(CALang.translateDirect("ponder.tesla_coil.text_2", new Object[0]).getString()).placeNearTarget().pointAt(topOf);
        scene.idle(80);
        scene.markAsFinished();
    }

    public static void teslaCoilHurt(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("tesla_coil_hurt", CALang.translateDirect("ponder.tesla_coil_hurt.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        BlockPos teslacoil = util.grid().at(2, 1, 2);
        BlockPos lever = util.grid().at(2, 1, 1);
        scene.world().showSection(util.select().position(teslacoil), Direction.DOWN);
        scene.idle(5);
        scene.overlay().showText(70).attachKeyFrame().text(CALang.translateDirect("ponder.tesla_coil_hurt.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(teslacoil));
        scene.idle(80);
        scene.world().showSection(util.select().position(lever), Direction.SOUTH);
        scene.idle(5);
        scene.overlay().showText(50).attachKeyFrame().text(CALang.translateDirect("ponder.tesla_coil_hurt.text_2", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().centerOf(lever));
        scene.idle(60);
        scene.world().setBlock(lever, (BlockState)((BlockState)((BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LeverBlock.f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)LeverBlock.f_53179_, (Comparable)AttachFace.FLOOR), false);
        scene.idle(5);
        scene.world().setBlock(teslacoil, (BlockState)((BlockState)CABlocks.TESLA_COIL.getDefaultState().m_61124_((Property)TeslaCoilBlock.FACING, (Comparable)Direction.DOWN)).m_61124_((Property)TeslaCoilBlock.POWERED, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(5);
        scene.overlay().showText(70).attachKeyFrame().text(CALang.translateDirect("ponder.tesla_coil_hurt.text_3", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(teslacoil));
        scene.idle(80);
        scene.markAsFinished();
    }

    public static void liquidBlazeBurner(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("liquid_blaze_burner", CALang.translateDirect("ponder.liquid_blaze_burner.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        BlockPos burner = util.grid().at(2, 1, 2);
        BlockPos[] blocks = new BlockPos[]{util.grid().at(1, 1, 2), util.grid().at(0, 1, 2), util.grid().at(0, 2, 2), util.grid().at(0, 3, 2)};
        scene.world().showSection(util.select().position(burner), Direction.DOWN);
        scene.idle(5);
        scene.overlay().showText(50).attachKeyFrame().text(CALang.translateDirect("ponder.liquid_blaze_burner.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(burner));
        scene.idle(10);
        scene.overlay().showControls(util.vector().topOf(burner), Pointing.DOWN, 40).rightClick().withItem(new ItemStack((ItemLike)CAItems.STRAW.get()));
        scene.world().setBlock(burner, (BlockState)CABlocks.LIQUID_BLAZE_BURNER.getDefaultState().m_61124_(LiquidBlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), false);
        scene.idle(60);
        scene.overlay().showText(50).attachKeyFrame().text(CALang.translateDirect("ponder.liquid_blaze_burner.text_2", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(burner));
        scene.idle(10);
        scene.overlay().showControls(util.vector().topOf(burner), Pointing.DOWN, 40).rightClick().withItem(new ItemStack((ItemLike)CAFluids.BIOETHANOL.getBucket().get()));
        scene.idle(60);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.liquid_blaze_burner.text_3", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().topOf(burner));
        scene.idle(10);
        for (int i = 0; i < blocks.length; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(blocks[i]), Direction.EAST);
        }
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void modularAccumulator(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("modular_accumulator", CALang.translateDirect("ponder.modular_accumulator.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 4);
        scene.showBasePlate();
        scene.idle(15);
        BlockPos cIn = new BlockPos(1, 3, 1);
        BlockPos cOut = new BlockPos(2, 3, 2);
        Selection accumulator = util.select().fromTo(1, 1, 1, 2, 2, 2);
        ElementLink accumulatorLink = scene.world().showIndependentSection(accumulator, Direction.EAST);
        scene.idle(15);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)accumulatorLink, accumulator, 50);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.modular_accumulator.text_1", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().centerOf(cIn));
        scene.idle(60);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.modular_accumulator.text_2", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().centerOf(cIn));
        scene.idle(60);
        scene.world().showSection(util.select().position(cIn), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(cOut), Direction.DOWN);
        scene.idle(15);
        scene.overlay().showControls(util.vector().centerOf(cIn), Pointing.DOWN, 0).rightClick().withItem(new ItemStack((ItemLike)AllItems.WRENCH.get()));
        scene.world().setBlock(cIn, (BlockState)((BlockState)CABlocks.SMALL_CONNECTOR.getDefaultState().m_61124_((Property)AbstractConnectorBlock.FACING, (Comparable)Direction.DOWN)).m_61124_(AbstractConnectorBlock.MODE, (Comparable)((Object)ConnectorMode.Push)), false);
        scene.overlay().showText(50).attachKeyFrame().text(CALang.translateDirect("ponder.modular_accumulator.text_3", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().centerOf(cIn));
        scene.idle(60);
        scene.overlay().showControls(util.vector().centerOf(cOut), Pointing.DOWN, 40).rightClick().withItem(new ItemStack((ItemLike)AllItems.WRENCH.get()));
        scene.world().setBlock(cOut, (BlockState)((BlockState)CABlocks.SMALL_CONNECTOR.getDefaultState().m_61124_((Property)AbstractConnectorBlock.FACING, (Comparable)Direction.DOWN)).m_61124_(AbstractConnectorBlock.MODE, (Comparable)((Object)ConnectorMode.Pull)), false);
        scene.overlay().showText(50).text(CALang.translateDirect("ponder.modular_accumulator.text_4", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().centerOf(cOut));
        scene.idle(60);
        scene.overlay().showText(110).text(CALang.translateDirect("ponder.modular_accumulator.text_5", new Object[0]).getString()).placeNearTarget().pointAt(util.vector().centerOf(cOut));
        scene.idle(120);
        scene.markAsFinished();
    }

    public static void peiTransfer(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("pei_transfer", CALang.translateDirect("ponder.pei_transfer.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.95f);
        scene.setSceneOffsetY(-1.0f);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.idle(5);
        BlockPos bearing = util.grid().at(5, 1, 2);
        scene.world().showSection(util.select().position(bearing), Direction.DOWN);
        scene.idle(5);
        ElementLink contraption = scene.world().showIndependentSection(util.select().fromTo(5, 2, 2, 6, 4, 2), Direction.DOWN);
        scene.world().configureCenterOfRotation(contraption, util.vector().centerOf(bearing));
        scene.idle(10);
        scene.world().rotateBearing(bearing, 360.0f, 70);
        scene.world().rotateSection(contraption, 0.0, 360.0, 0.0, 70);
        scene.overlay().showText(60).pointAt(util.vector().topOf(bearing.m_6630_(2))).colored(PonderPalette.RED).placeNearTarget().attachKeyFrame().text(CALang.translateDirect("ponder.pei_transfer.text_1", new Object[0]).getString());
        scene.idle(70);
        BlockPos pei = util.grid().at(4, 2, 2);
        scene.world().showSectionAndMerge(util.select().position(pei), Direction.EAST, contraption);
        scene.idle(13);
        scene.effects().superGlue(pei, Direction.EAST, true);
        scene.overlay().showText(80).pointAt(util.vector().topOf(pei)).colored(PonderPalette.GREEN).placeNearTarget().attachKeyFrame().text(CALang.translateDirect("ponder.pei_transfer.text_2", new Object[0]).getString());
        scene.idle(90);
        BlockPos pei2 = pei.m_122025_(2);
        scene.world().showSection(util.select().position(pei2), Direction.DOWN);
        scene.overlay().showOutlineWithText(util.select().position(pei.m_122024_()), 50).colored(PonderPalette.RED).placeNearTarget().attachKeyFrame().text(CALang.translateDirect("ponder.pei_transfer.text_3", new Object[0]).getString());
        scene.idle(55);
        scene.world().rotateBearing(bearing, 360.0f, 60);
        scene.world().rotateSection(contraption, 0.0, 360.0, 0.0, 60);
        scene.idle(20);
        scene.overlay().showText(40).placeNearTarget().pointAt(util.vector().of(3.0, 3.0, 2.5)).text(CALang.translateDirect("ponder.pei_transfer.text_4", new Object[0]).getString());
        scene.idle(35);
        Selection both = util.select().fromTo(2, 2, 2, 4, 2, 2);
        Class<PortableEnergyInterfaceBlockEntity> peiClass = PortableEnergyInterfaceBlockEntity.class;
        scene.world().modifyBlockEntityNBT(both, peiClass, nbt -> {
            nbt.m_128350_("Distance", 1.0f);
            nbt.m_128350_("Timer", 40.0f);
        });
        scene.idle(20);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)pei, util.select().fromTo(5, 3, 2, 6, 4, 2), 80);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().position(pei2), 70).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text(CALang.translateDirect("ponder.pei_transfer.text_5", new Object[0]).getString());
        scene.idle(80);
        BlockPos connector = util.grid().at(2, 3, 2);
        scene.world().showSection(util.select().position(connector), Direction.DOWN);
        scene.overlay().showText(70).placeNearTarget().pointAt(util.vector().centerOf(connector)).attachKeyFrame().text(CALang.translateDirect("ponder.pei_transfer.text_6", new Object[0]).getString());
        scene.idle(80);
        scene.overlay().showText(120).placeNearTarget().pointAt(util.vector().centerOf(pei2)).text(CALang.translateDirect("ponder.pei_transfer.text_7", new Object[0]).getString());
        scene.world().modifyBlockEntityNBT(both, peiClass, nbt -> nbt.m_128350_("Timer", 9.0f));
        scene.idle(15);
        scene.world().rotateBearing(bearing, 270.0f, 120);
        scene.world().rotateSection(contraption, 0.0, 270.0, 0.0, 120);
        scene.markAsFinished();
    }

    public static void peiRedstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("pei_redstone", CALang.translateDirect("ponder.pei_redstone.header", new Object[0]).getString());
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        Class<PortableEnergyInterfaceBlockEntity> peiClass = PortableEnergyInterfaceBlockEntity.class;
        Selection peis = util.select().fromTo(1, 1, 3, 1, 3, 3);
        scene.world().modifyBlockEntityNBT(peis, peiClass, nbt -> {
            nbt.m_128350_("Distance", 1.0f);
            nbt.m_128350_("Timer", 40.0f);
        });
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.idle(5);
        scene.world().showSection(util.select().layer(1), Direction.DOWN);
        scene.idle(5);
        ElementLink contraption = scene.world().showIndependentSection(util.select().layersFrom(2), Direction.DOWN);
        BlockPos bearing = util.grid().at(3, 1, 3);
        scene.world().configureCenterOfRotation(contraption, util.vector().topOf(bearing));
        scene.idle(20);
        scene.world().modifyBlockEntityNBT(peis, peiClass, nbt -> nbt.m_128350_("Timer", 9.0f));
        scene.idle(20);
        scene.world().rotateBearing(bearing, 1350.0f, 300);
        scene.world().rotateSection(contraption, 0.0, 1350.0, 0.0, 300);
        scene.idle(20);
        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 1, 1, 1, 2));
        scene.effects().indicateRedstone(util.grid().at(1, 1, 1));
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().position(1, 1, 3), 120).colored(PonderPalette.RED).text(CALang.translateDirect("ponder.pei_redstone.text_1", new Object[0]).getString());
        scene.idle(20);
        scene.markAsFinished();
    }
}

