/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.recipe;

import com.simibubi.create.AllRecipeTypes;
import javax.annotation.Nullable;
import net.createmod.catnip.data.IntAttached;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ItemCopyingRecipe
extends CustomRecipe {
    public ItemCopyingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        return this.copyCheck(inv) != null;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        IntAttached<ItemStack> copyCheck = this.copyCheck(container);
        if (copyCheck == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemToCopy = (ItemStack)copyCheck.getValue();
        Item item = itemToCopy.m_41720_();
        if (!(item instanceof SupportsItemCopying)) {
            return ItemStack.f_41583_;
        }
        SupportsItemCopying sic = (SupportsItemCopying)item;
        return sic.createCopy(itemToCopy, (Integer)copyCheck.getFirst() + 1);
    }

    @Nullable
    private IntAttached<ItemStack> copyCheck(CraftingContainer inv) {
        SupportsItemCopying sic;
        Item item;
        ItemStack itemInSlot;
        int j;
        ItemStack itemToCopy = ItemStack.f_41583_;
        int copyTargets = 0;
        for (j = 0; j < inv.m_6643_(); ++j) {
            itemInSlot = inv.m_8020_(j);
            if (itemInSlot.m_41619_()) continue;
            item = itemInSlot.m_41720_();
            if (!(item instanceof SupportsItemCopying)) {
                return null;
            }
            sic = (SupportsItemCopying)item;
            if (!sic.canCopyFromItem(itemInSlot)) continue;
            itemToCopy = itemInSlot;
            break;
        }
        if (itemToCopy.m_41619_()) {
            return null;
        }
        for (j = 0; j < inv.m_6643_(); ++j) {
            itemInSlot = inv.m_8020_(j);
            if (itemInSlot.m_41619_() || itemInSlot == itemToCopy) continue;
            if (itemToCopy.m_41720_() != itemInSlot.m_41720_()) {
                return null;
            }
            item = itemInSlot.m_41720_();
            if (!(item instanceof SupportsItemCopying)) {
                return null;
            }
            sic = (SupportsItemCopying)item;
            if (sic.canCopyFromItem(itemInSlot)) {
                return null;
            }
            if (!sic.canCopyToItem(itemInSlot)) {
                return null;
            }
            ++copyTargets;
        }
        if (copyTargets == 0) {
            return null;
        }
        return IntAttached.with((int)copyTargets, (Object)itemToCopy);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return AllRecipeTypes.ITEM_COPYING.getSerializer();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public static interface SupportsItemCopying {
        default public ItemStack createCopy(ItemStack original, int count) {
            ItemStack copyWithCount = original.m_255036_(count);
            copyWithCount.m_41749_("Enchantments");
            return copyWithCount;
        }

        default public boolean canCopyFromItem(ItemStack item) {
            return item.m_41782_();
        }

        default public boolean canCopyToItem(ItemStack item) {
            return !item.m_41782_();
        }
    }
}

