/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.content.logistics.item.filter.attribute.SingletonItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.AddedByAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.BookAuthorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.BookCopyAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ColorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.EnchantAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.FluidContentsAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.InItemGroupAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ItemNameAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ShulkerFillLevelAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryAmuletAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryAttunementAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryCrystalAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryPerkGemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.legacydeserializers.AllItemAttributeLegacyDeserializers;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class AllItemAttributeTypes {
    private static final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    public static final ItemAttributeType PLACEABLE = AllItemAttributeTypes.singleton("placeable", (ItemStack s) -> s.m_41720_() instanceof BlockItem);
    public static final ItemAttributeType CONSUMABLE = AllItemAttributeTypes.singleton("consumable", ItemStack::m_41614_);
    public static final ItemAttributeType FLUID_CONTAINER = AllItemAttributeTypes.singleton("fluid_container", (ItemStack s) -> s.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent());
    public static final ItemAttributeType ENCHANTED = AllItemAttributeTypes.singleton("enchanted", ItemStack::m_41793_);
    public static final ItemAttributeType MAX_ENCHANTED = AllItemAttributeTypes.singleton("max_enchanted", AllItemAttributeTypes::maxEnchanted);
    public static final ItemAttributeType RENAMED = AllItemAttributeTypes.singleton("renamed", ItemStack::m_41788_);
    public static final ItemAttributeType DAMAGED = AllItemAttributeTypes.singleton("damaged", ItemStack::m_41768_);
    public static final ItemAttributeType BADLY_DAMAGED = AllItemAttributeTypes.singleton("badly_damaged", (ItemStack s) -> s.m_41768_() && (float)s.m_41773_() / (float)s.m_41776_() > 0.75f);
    public static final ItemAttributeType NOT_STACKABLE = AllItemAttributeTypes.singleton("not_stackable", ((Predicate<ItemStack>)ItemStack::m_41753_).negate());
    public static final ItemAttributeType EQUIPABLE = AllItemAttributeTypes.singleton("equipable", (ItemStack s) -> LivingEntity.m_147233_((ItemStack)s).m_20743_() != EquipmentSlot.Type.HAND);
    public static final ItemAttributeType FURNACE_FUEL = AllItemAttributeTypes.singleton("furnace_fuel", AbstractFurnaceBlockEntity::m_58399_);
    public static final ItemAttributeType WASHABLE = AllItemAttributeTypes.singleton("washable", AllFanProcessingTypes.SPLASHING::canProcess);
    public static final ItemAttributeType HAUNTABLE = AllItemAttributeTypes.singleton("hauntable", AllFanProcessingTypes.HAUNTING::canProcess);
    public static final ItemAttributeType CRUSHABLE = AllItemAttributeTypes.singleton("crushable", (ItemStack s, Level w) -> AllItemAttributeTypes.testRecipe(s, w, AllRecipeTypes.CRUSHING.getType()) || AllItemAttributeTypes.testRecipe(s, w, AllRecipeTypes.MILLING.getType()));
    public static final ItemAttributeType SMELTABLE = AllItemAttributeTypes.singleton("smeltable", (ItemStack s, Level w) -> AllItemAttributeTypes.testRecipe(s, w, RecipeType.f_44108_));
    public static final ItemAttributeType SMOKABLE = AllItemAttributeTypes.singleton("smokable", (ItemStack s, Level w) -> AllItemAttributeTypes.testRecipe(s, w, RecipeType.f_44110_));
    public static final ItemAttributeType BLASTABLE = AllItemAttributeTypes.singleton("blastable", (ItemStack s, Level w) -> AllItemAttributeTypes.testRecipe(s, w, RecipeType.f_44109_));
    public static final ItemAttributeType COMPOSTABLE = AllItemAttributeTypes.singleton("compostable", (ItemStack s) -> ComposterBlock.f_51914_.containsKey((Object)s.m_41720_()));
    public static final ItemAttributeType IN_TAG = AllItemAttributeTypes.register("in_tag", new InTagAttribute.Type());
    public static final ItemAttributeType IN_ITEM_GROUP = AllItemAttributeTypes.register("in_item_group", new InItemGroupAttribute.Type());
    public static final ItemAttributeType ADDED_BY = AllItemAttributeTypes.register("added_by", new AddedByAttribute.Type());
    public static final ItemAttributeType HAS_ENCHANT = AllItemAttributeTypes.register("has_enchant", new EnchantAttribute.Type());
    public static final ItemAttributeType SHULKER_FILL_LEVEL = AllItemAttributeTypes.register("shulker_fill_level", new ShulkerFillLevelAttribute.Type());
    public static final ItemAttributeType HAS_COLOR = AllItemAttributeTypes.register("has_color", new ColorAttribute.Type());
    public static final ItemAttributeType HAS_FLUID = AllItemAttributeTypes.register("has_fluid", new FluidContentsAttribute.Type());
    public static final ItemAttributeType HAS_NAME = AllItemAttributeTypes.register("has_name", new ItemNameAttribute.Type());
    public static final ItemAttributeType BOOK_AUTHOR = AllItemAttributeTypes.register("book_author", new BookAuthorAttribute.Type());
    public static final ItemAttributeType BOOK_COPY = AllItemAttributeTypes.register("book_copy", new BookCopyAttribute.Type());
    public static final ItemAttributeType ASTRAL_AMULET = AllItemAttributeTypes.register("astral_amulet", new AstralSorceryAmuletAttribute.Type());
    public static final ItemAttributeType ASTRAL_ATTUNMENT = AllItemAttributeTypes.register("astral_attunment", new AstralSorceryAttunementAttribute.Type());
    public static final ItemAttributeType ASTRAL_CRYSTAL = AllItemAttributeTypes.register("astral_crystal", new AstralSorceryCrystalAttribute.Type());
    public static final ItemAttributeType ASTRAL_PERK_GEM = AllItemAttributeTypes.register("astral_perk_gem", new AstralSorceryPerkGemAttribute.Type());

    private static <T extends Recipe<Container>> boolean testRecipe(ItemStack s, Level w, RecipeType<T> type) {
        RECIPE_WRAPPER.m_6836_(0, s.m_41777_());
        return w.m_7465_().m_44015_(type, (Container)RECIPE_WRAPPER, w).isPresent();
    }

    private static boolean maxEnchanted(ItemStack s) {
        return EnchantmentHelper.m_44831_((ItemStack)s).entrySet().stream().anyMatch(e -> ((Enchantment)e.getKey()).m_6586_() <= (Integer)e.getValue());
    }

    private static ItemAttributeType singleton(String id, Predicate<ItemStack> predicate) {
        return AllItemAttributeTypes.register(id, new SingletonItemAttribute.Type(type -> new SingletonItemAttribute((SingletonItemAttribute.Type)type, (stack, level) -> predicate.test((ItemStack)stack), id)));
    }

    private static ItemAttributeType singleton(String id, BiPredicate<ItemStack, Level> predicate) {
        return AllItemAttributeTypes.register(id, new SingletonItemAttribute.Type(type -> new SingletonItemAttribute((SingletonItemAttribute.Type)type, predicate, id)));
    }

    private static ItemAttributeType register(String id, ItemAttributeType type) {
        return (ItemAttributeType)Registry.m_122965_(CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE, (ResourceLocation)Create.asResource(id), (Object)type);
    }

    public static void init() {
    }

    static {
        AllItemAttributeLegacyDeserializers.register();
    }
}

