/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.crafter.ConnectedInputHandler;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.RecipeGridHandler;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.math.BlockFace;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class MechanicalCrafterBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity {
    protected Inventory inventory;
    protected RecipeGridHandler.GroupedItems groupedItems = new RecipeGridHandler.GroupedItems();
    protected ConnectedInputHandler.ConnectedInput input = new ConnectedInputHandler.ConnectedInput();
    protected LazyOptional<IItemHandler> invSupplier = LazyOptional.of(() -> this.input.getItemHandler(this.f_58857_, this.f_58858_));
    protected boolean reRender;
    protected Phase phase;
    protected int countDown;
    protected boolean covered;
    protected boolean wasPoweredBefore;
    protected RecipeGridHandler.GroupedItems groupedItemsBeforeCraft;
    private InvManipulationBehaviour inserting;
    private EdgeInteractionBehaviour connectivity;
    private ItemStack scriptedResult = ItemStack.f_41583_;

    public MechanicalCrafterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
        this.phase = Phase.IDLE;
        this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
        this.inventory = new Inventory(this);
        this.wasPoweredBefore = true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        this.connectivity = new EdgeInteractionBehaviour(this, ConnectedInputHandler::toggleConnection).connectivity(ConnectedInputHandler::shouldConnect).require(AllTags.AllItemTags.WRENCH::matches);
        behaviours.add(this.inserting);
        behaviours.add(this.connectivity);
        this.registerAwardables(behaviours, AllAdvancements.CRAFTER, AllAdvancements.CRAFTER_LAZY);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (!Mth.m_14033_((float)this.getSpeed(), (float)0.0f)) {
            this.award(AllAdvancements.CRAFTER);
            if (Math.abs(this.getSpeed()) < 5.0f) {
                this.award(AllAdvancements.CRAFTER_LAZY);
            }
        }
    }

    public void blockChanged() {
        this.removeBehaviour(InvManipulationBehaviour.TYPE);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        this.attachBehaviourLate(this.inserting);
    }

    public BlockFace getTargetFace(Level world, BlockPos pos, BlockState state) {
        return new BlockFace(pos, MechanicalCrafterBlock.getTargetDirection(state));
    }

    public Direction getTargetDirection() {
        return MechanicalCrafterBlock.getTargetDirection(this.m_58900_());
    }

    @Override
    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
        if (this.input == null) {
            return;
        }
        CompoundTag inputNBT = new CompoundTag();
        this.input.write(inputNBT);
        compound.m_128365_("ConnectedInput", (Tag)inputNBT);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag inputNBT = new CompoundTag();
        this.input.write(inputNBT);
        compound.m_128365_("ConnectedInput", (Tag)inputNBT);
        CompoundTag groupedItemsNBT = new CompoundTag();
        this.groupedItems.write(groupedItemsNBT);
        compound.m_128365_("GroupedItems", (Tag)groupedItemsNBT);
        compound.m_128359_("Phase", this.phase.name());
        compound.m_128405_("CountDown", this.countDown);
        compound.m_128379_("Cover", this.covered);
        super.write(compound, clientPacket);
        if (clientPacket && this.reRender) {
            compound.m_128379_("Redraw", true);
            this.reRender = false;
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        Phase phaseBefore = this.phase;
        RecipeGridHandler.GroupedItems before = this.groupedItems;
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.input.read(compound.m_128469_("ConnectedInput"));
        this.groupedItems = RecipeGridHandler.GroupedItems.read(compound.m_128469_("GroupedItems"));
        this.phase = Phase.IDLE;
        String name = compound.m_128461_("Phase");
        for (Phase phase : Phase.values()) {
            if (!phase.name().equals(name)) continue;
            this.phase = phase;
        }
        this.countDown = compound.m_128451_("CountDown");
        this.covered = compound.m_128471_("Cover");
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (compound.m_128441_("Redraw")) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
        if (phaseBefore != this.phase && this.phase == Phase.CRAFTING) {
            this.groupedItemsBeforeCraft = before;
        }
        if (phaseBefore == Phase.EXPORTING && this.phase == Phase.WAITING) {
            if (before.onlyEmptyItems()) {
                return;
            }
            Direction facing = (Direction)this.m_58900_().m_61143_(MechanicalCrafterBlock.HORIZONTAL_FACING);
            Vec3 vec = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.75).m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
            Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(this.m_58900_());
            vec = vec.m_82549_(Vec3.m_82528_((Vec3i)targetDirection.m_122436_()).m_82490_(1.0));
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invSupplier.invalidate();
    }

    public int getCountDownSpeed() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed())), (int)4, (int)250);
    }

    @Override
    public void tick() {
        boolean runLogic;
        super.tick();
        if (this.phase == Phase.ACCEPTING) {
            return;
        }
        boolean onClient = this.f_58857_.f_46443_;
        boolean bl = runLogic = !onClient || this.isVirtual();
        if (this.wasPoweredBefore != this.f_58857_.m_276867_(this.f_58858_)) {
            this.wasPoweredBefore = this.f_58857_.m_276867_(this.f_58858_);
            if (this.wasPoweredBefore) {
                if (!runLogic) {
                    return;
                }
                this.checkCompletedRecipe(true);
            }
        }
        if (this.phase == Phase.ASSEMBLING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                ItemStack result;
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                if (RecipeGridHandler.getTargetingCrafter(this) != null) {
                    this.phase = Phase.EXPORTING;
                    this.countDown = this.groupedItems.onlyEmptyItems() ? 0 : 1000;
                    this.sendData();
                    return;
                }
                ItemStack itemStack = result = this.isVirtual() ? this.scriptedResult : RecipeGridHandler.tryToApplyRecipe(this.f_58857_, this.groupedItems);
                if (result != null) {
                    ArrayList containers = new ArrayList();
                    this.groupedItems.grid.values().forEach(stack -> {
                        if (stack.hasCraftingRemainingItem()) {
                            containers.add(stack.getCraftingRemainingItem().m_41777_());
                        }
                    });
                    if (this.isVirtual()) {
                        this.groupedItemsBeforeCraft = this.groupedItems;
                    }
                    this.groupedItems = new RecipeGridHandler.GroupedItems(result);
                    for (int i = 0; i < containers.size(); ++i) {
                        ItemStack stack2 = (ItemStack)containers.get(i);
                        RecipeGridHandler.GroupedItems container = new RecipeGridHandler.GroupedItems();
                        container.grid.put((Pair<Integer, Integer>)Pair.of((Object)i, (Object)0), stack2);
                        container.mergeOnto(this.groupedItems, Pointing.LEFT);
                    }
                    this.phase = Phase.CRAFTING;
                    this.countDown = 2000;
                    this.sendData();
                    return;
                }
                this.ejectWholeGrid();
                return;
            }
        }
        if (this.phase == Phase.EXPORTING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                MechanicalCrafterBlockEntity targetingCrafter = RecipeGridHandler.getTargetingCrafter(this);
                if (targetingCrafter == null) {
                    this.ejectWholeGrid();
                    return;
                }
                boolean empty = this.groupedItems.onlyEmptyItems();
                Pointing pointing = (Pointing)this.m_58900_().m_61143_(MechanicalCrafterBlock.POINTING);
                this.groupedItems.mergeOnto(targetingCrafter.groupedItems, pointing);
                this.groupedItems = new RecipeGridHandler.GroupedItems();
                float pitch = (float)(targetingCrafter.groupedItems.grid.size() * 1) / 16.0f + 0.5f;
                if (!empty) {
                    AllSoundEvents.CRAFTER_CLICK.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, pitch);
                }
                this.phase = Phase.WAITING;
                this.countDown = 0;
                this.sendData();
                targetingCrafter.continueIfAllPrecedingFinished();
                targetingCrafter.sendData();
                return;
            }
        }
        if (this.phase == Phase.CRAFTING) {
            if (onClient) {
                Direction facing = (Direction)this.m_58900_().m_61143_(MechanicalCrafterBlock.HORIZONTAL_FACING);
                float progress = (float)this.countDown / 2000.0f;
                Vec3 facingVec = Vec3.m_82528_((Vec3i)facing.m_122436_());
                Vec3 vec = facingVec.m_82490_(0.65).m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
                Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.125f).m_82559_(VecHelper.axisAlingedPlaneOf((Vec3)facingVec)).m_82541_().m_82490_((double)(progress * 0.5f)).m_82549_(vec);
                if (progress > 0.5f) {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
                }
                if (!this.groupedItemsBeforeCraft.grid.isEmpty() && progress < 0.5f && this.groupedItems.grid.containsKey(Pair.of((Object)0, (Object)0))) {
                    ItemStack stack3 = this.groupedItems.grid.get(Pair.of((Object)0, (Object)0));
                    this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
                    for (int i = 0; i < 10; ++i) {
                        Vec3 randVec = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.125f).m_82559_(VecHelper.axisAlingedPlaneOf((Vec3)facingVec)).m_82541_().m_82490_(0.25);
                        Vec3 offset2 = randVec.m_82549_(vec);
                        randVec = randVec.m_82490_((double)0.35f);
                        this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack3), offset2.f_82479_, offset2.f_82480_, offset2.f_82481_, randVec.f_82479_, randVec.f_82480_, randVec.f_82481_);
                    }
                }
            }
            int prev = this.countDown;
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 1000 && prev >= 1000) {
                AllSoundEvents.CRAFTER_CLICK.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 2.0f);
                AllSoundEvents.CRAFTER_CRAFT.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
            }
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                this.tryInsert();
                return;
            }
        }
        if (this.phase == Phase.INSERTING) {
            if (runLogic && this.isTargetingBelt()) {
                this.tryInsert();
            }
            return;
        }
    }

    protected boolean isTargetingBelt() {
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        return behaviour != null && behaviour.canInsertFromSide(this.getTargetDirection());
    }

    protected DirectBeltInputBehaviour getTargetingBelt() {
        BlockPos targetPos = this.f_58858_.m_121945_(this.getTargetDirection());
        return BlockEntityBehaviour.get((BlockGetter)this.f_58857_, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public void tryInsert() {
        if (!this.inserting.hasInventory() && !this.isTargetingBelt()) {
            this.ejectWholeGrid();
            return;
        }
        boolean chagedPhase = this.phase != Phase.INSERTING;
        LinkedList<Pair<Integer, Integer>> inserted = new LinkedList<Pair<Integer, Integer>>();
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        for (Map.Entry<Pair<Integer, Integer>, ItemStack> entry : this.groupedItems.grid.entrySet()) {
            ItemStack remainder;
            Pair<Integer, Integer> pair = entry.getKey();
            ItemStack stack = entry.getValue();
            BlockFace face = this.getTargetFace(this.f_58857_, this.f_58858_, this.m_58900_());
            ItemStack itemStack = remainder = behaviour == null ? this.inserting.insert(stack.m_41777_()) : behaviour.handleInsertion(stack, face.getFace(), false);
            if (!remainder.m_41619_()) {
                stack.m_41764_(remainder.m_41613_());
                continue;
            }
            inserted.add(pair);
        }
        inserted.forEach(this.groupedItems.grid::remove);
        if (this.groupedItems.grid.isEmpty()) {
            this.ejectWholeGrid();
        } else {
            this.phase = Phase.INSERTING;
        }
        if (!inserted.isEmpty() || chagedPhase) {
            this.sendData();
        }
    }

    public void ejectWholeGrid() {
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChain(this);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterBlockEntity::eject);
    }

    public void eject() {
        BlockState blockState = this.m_58900_();
        boolean present = AllBlocks.MECHANICAL_CRAFTER.has(blockState);
        Vec3 vec = present ? Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122436_()).m_82490_(0.75) : Vec3.f_82478_;
        Vec3 ejectPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(vec);
        this.groupedItems.grid.forEach((pair, stack) -> this.dropItem(ejectPos, (ItemStack)stack));
        if (!this.inventory.m_8020_(0).m_41619_()) {
            this.dropItem(ejectPos, this.inventory.m_8020_(0));
        }
        this.phase = Phase.IDLE;
        this.groupedItems = new RecipeGridHandler.GroupedItems();
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        this.sendData();
    }

    public void dropItem(Vec3 ejectPos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, ejectPos.f_82479_, ejectPos.f_82480_, ejectPos.f_82481_, stack);
        itemEntity.m_32060_();
        this.f_58857_.m_7967_((Entity)itemEntity);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (this.phase == Phase.IDLE && this.craftingItemPresent()) {
            this.checkCompletedRecipe(false);
        }
        if (this.phase == Phase.INSERTING) {
            this.tryInsert();
        }
    }

    public boolean craftingItemPresent() {
        return !this.inventory.m_8020_(0).m_41619_();
    }

    public boolean craftingItemOrCoverPresent() {
        return !this.inventory.m_8020_(0).m_41619_() || this.covered;
    }

    public void checkCompletedRecipe(boolean poweredStart) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChainIf(this, poweredStart ? MechanicalCrafterBlockEntity::craftingItemPresent : MechanicalCrafterBlockEntity::craftingItemOrCoverPresent, poweredStart);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterBlockEntity::begin);
    }

    protected void begin() {
        this.phase = Phase.ACCEPTING;
        this.groupedItems = new RecipeGridHandler.GroupedItems(this.inventory.m_8020_(0));
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        if (RecipeGridHandler.getPrecedingCrafters(this).isEmpty()) {
            this.phase = Phase.ASSEMBLING;
            this.countDown = 1;
        }
        this.sendData();
    }

    protected void continueIfAllPrecedingFinished() {
        List<MechanicalCrafterBlockEntity> preceding = RecipeGridHandler.getPrecedingCrafters(this);
        if (preceding == null) {
            this.ejectWholeGrid();
            return;
        }
        for (MechanicalCrafterBlockEntity blockEntity : preceding) {
            if (blockEntity.phase == Phase.WAITING) continue;
            return;
        }
        this.phase = Phase.ASSEMBLING;
        this.countDown = 1;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.invSupplier.cast();
        }
        return super.getCapability(cap, side);
    }

    public void connectivityChanged() {
        this.reRender = true;
        this.sendData();
        this.invSupplier.invalidate();
        this.invSupplier = LazyOptional.of(() -> this.input.getItemHandler(this.f_58857_, this.f_58858_));
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setScriptedResult(ItemStack scriptedResult) {
        this.scriptedResult = scriptedResult;
    }

    public ConnectedInputHandler.ConnectedInput getInput() {
        return this.input;
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        this.input.data.replaceAll(transform::applyWithoutOffset);
        this.notifyUpdate();
    }

    static enum Phase {
        IDLE,
        ACCEPTING,
        ASSEMBLING,
        EXPORTING,
        WAITING,
        CRAFTING,
        INSERTING;

    }

    public static class Inventory
    extends SmartInventory {
        private MechanicalCrafterBlockEntity blockEntity;

        public Inventory(MechanicalCrafterBlockEntity blockEntity) {
            super(1, blockEntity, 1, false);
            this.blockEntity = blockEntity;
            this.forbidExtraction();
            this.whenContentsChanged(slot -> {
                if (this.m_8020_((int)slot).m_41619_()) {
                    return;
                }
                if (blockEntity.phase == Phase.IDLE) {
                    blockEntity.checkCompletedRecipe(false);
                }
            });
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.blockEntity.phase != Phase.IDLE) {
                return stack;
            }
            if (this.blockEntity.covered) {
                return stack;
            }
            ItemStack insertItem = super.insertItem(slot, stack, simulate);
            if (insertItem.m_41613_() != stack.m_41613_() && !simulate) {
                this.blockEntity.m_58904_().m_5594_(null, this.blockEntity.m_58899_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 0.5f);
            }
            return insertItem;
        }
    }
}

