/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.client.particle.AbstractRibbonTrailParticle;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class SidedRibbonTrailParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("companions", "textures/particle/trail.png");
    protected final float radius;
    protected final float height;
    protected final int targetId;
    protected final float startYaw;
    protected final float yawSpeed;
    protected float ribbonHeight;
    protected int side;

    public SidedRibbonTrailParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float radius, float height, int targetId, int side) {
        super(level, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.radius = radius;
        this.height = height;
        this.targetId = targetId;
        this.side = side;
        this.f_107226_ = 0.0f;
        this.f_107225_ = 60;
        this.startYaw = level.f_46441_.m_188501_() * 360.0f;
        this.yawSpeed = (5.0f + level.f_46441_.m_188501_() * 5.0f) * (level.f_46441_.m_188499_() ? 1.0f : -1.0f);
        this.ribbonHeight = 0.35f;
        this.m_107264_(this.targetPos().f_82479_, this.targetPos().f_82480_, this.targetPos().f_82481_);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.getTarget() == null && this.targetId != -1) {
            this.m_107274_();
            return;
        }
        this.ribbonAlpha = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.m_107264_(this.targetPos().f_82479_, this.targetPos().f_82480_, this.targetPos().f_82481_);
    }

    protected Vec3 targetPos() {
        if (this.getTarget() == null) {
            return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        }
        Vec3 dir = this.getTarget().m_20184_().m_82541_();
        if (dir.m_82556_() < 1.0E-6) {
            return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        }
        Vec3 perp = new Vec3(-dir.f_82481_, 0.0, dir.f_82479_).m_82541_().m_82490_(1.5);
        double y = this.getTarget().m_20186_();
        Vec3 right = new Vec3(this.getTarget().m_20185_(), y, this.getTarget().m_20189_()).m_82549_(perp);
        Vec3 left = new Vec3(this.getTarget().m_20185_(), y, this.getTarget().m_20189_()).m_82546_(perp);
        if (this.side == 0) {
            return new Vec3(left.f_82479_, left.f_82480_, left.f_82481_);
        }
        return new Vec3(right.f_82479_, right.f_82480_, right.f_82481_);
    }

    @Nullable
    private Entity getTarget() {
        return this.targetId == -1 ? null : this.f_107208_.m_6815_(this.targetId);
    }

    protected float getRibbonHeight() {
        return this.ribbonHeight;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return 5;
    }
}

