/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CakeCreamParticle
extends TextureSheetParticle {
    private final SpriteSet spritesset;
    private boolean hasLanded = false;
    private int landedTicks = 0;
    private static double defaultVelocityX = 0.0;
    private static double defaultVelocityY = 0.0;
    private static double defaultVelocityZ = 0.0;

    public static void setDefaultVelocity(double vx, double vy, double vz) {
        defaultVelocityX = vx;
        defaultVelocityY = vy;
        defaultVelocityZ = vz;
    }

    CakeCreamParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y + 0.5, z);
        this.f_107663_ = new Random().nextFloat(0.15f, 0.4f);
        this.f_107225_ = new Random().nextInt(50) + 20;
        this.m_108339_(sprites);
        this.spritesset = sprites;
        this.f_107226_ = 0.15f;
        this.f_107230_ = 0.0f;
        if (velX == 0.0 && velY == 0.0 && velZ == 0.0) {
            this.f_107215_ = defaultVelocityX;
            this.f_107216_ = defaultVelocityY;
            this.f_107217_ = defaultVelocityZ;
        } else {
            this.f_107215_ = velX;
            this.f_107216_ = velY;
            this.f_107217_ = velZ;
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.hasLanded) {
            ++this.landedTicks;
            if (this.landedTicks >= 40) {
                this.m_107274_();
            }
            return;
        }
        super.m_5989_();
        this.m_108339_(this.spritesset);
        this.f_107230_ = this.f_107224_ < 4 ? (float)this.f_107224_ / 5.0f : 1.0f;
        this.f_107215_ *= 0.98;
        this.f_107216_ *= 0.98;
        this.f_107217_ *= 0.98;
    }

    public static Vec3 randomVectorInCone(Vec3 base, double alpha) {
        Vec3 baseNorm = base.m_82541_();
        Vec3 u = baseNorm.m_82537_(new Vec3(0.0, 1.0, 0.0));
        if (u.m_82556_() < 1.0E-6) {
            u = baseNorm.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        u = u.m_82541_();
        Vec3 v = baseNorm.m_82537_(u).m_82541_();
        double minCos = Math.cos(Math.toRadians(alpha));
        double cos = minCos + new Random().nextDouble() * (1.0 - minCos);
        double sin = Math.sqrt(1.0 - cos * cos);
        double phi = new Random().nextDouble() * 2.0 * Math.PI;
        return baseNorm.m_82490_(cos).m_82549_(u.m_82490_(sin * Math.cos(phi))).m_82549_(v.m_82490_(sin * Math.sin(phi))).m_82490_(base.m_82553_());
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
                Vec3 b = new Vec3(defaultVelocityX, defaultVelocityY, defaultVelocityZ);
                Vec3 v = CakeCreamParticle.randomVectorInCone(b, 15.0);
                double f = 0.8 + new Random().nextDouble() * 0.4;
                dx = v.f_82479_ * f;
                dy = v.f_82480_ * f;
                dz = v.f_82481_ * f;
            }
            CakeCreamParticle particle = new CakeCreamParticle(level, x, y, z, this.sprites, dx, dy, dz);
            particle.m_107264_(x, y, z);
            return particle;
        }
    }
}

