/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FireMarkRingProjectile
extends BaseProjectile {
    private final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("activate");
    private final double RADIUS = CompanionsConfig.FIRE_MARK_EFFECT_RADIUS;

    public FireMarkRingProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.m_20185_() - this.RADIUS, this.m_20186_() - 1.0, this.m_20189_() - this.RADIUS, this.m_20185_() + this.RADIUS, this.m_20186_() + 1.0, this.m_20189_() + this.RADIUS), e -> !Util.areEntitiesLinked((Entity)this, (Entity)e))) {
                if (entity.m_21023_(CompanionsEffects.FIRE_MARK.get())) continue;
                entity.m_7292_(new MobEffectInstance(CompanionsEffects.FIRE_MARK.get(), this.m_9236_().f_46441_.m_216339_(100, 400), 0, true, true));
                entity.m_216990_(CompanionsSounds.SPELL_HIT_MARK.get());
            }
        }
        if (this.f_19797_ >= this.getLifetime()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    @Override
    protected int baseLifetime() {
        return 30;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.ACTIVATE);
        return PlayState.CONTINUE;
    }
}

