/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.hostile.BrokenDinamoEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IllagerGolemEntity
extends Raider
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public List<Entity> visibleEntities = new ArrayList<Entity>();
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("roll");
    private final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIMATION_START_TICK = SynchedEntityData.m_135353_(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TICKCOUNT = SynchedEntityData.m_135353_(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TEST_TIMER = SynchedEntityData.m_135353_(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int TIME_PER_ACTIVATION = 60;
    public static final int ELECTRICAL_CHARGE_DURATION = 8;

    public IllagerGolemEntity(EntityType<? extends Raider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 0.01f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier setAttributes() {
        return Raider.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TickCount", this.getTickCount());
        tag.m_128405_("AnimationStartTick", this.getAnimationStartTick());
    }

    public void m_20258_(@NotNull CompoundTag tag) {
        super.m_20258_(tag);
        this.setAnimationStartTick(tag.m_128451_("TickCount"));
        this.setAnimationStartTick(tag.m_128451_("AnimationStartTick"));
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("TickCount")) {
            this.setTickCount(tag.m_128451_("TickCount"));
        } else {
            this.setTickCount(0);
        }
        if (tag.m_128441_("AnimationStartTick")) {
            this.setAnimationStartTick(tag.m_128451_("AnimationStartTick"));
        } else {
            this.setAnimationStartTick(0);
        }
    }

    public int getAnimationStartTick() {
        return (Integer)this.f_19804_.m_135370_(TEST_TIMER);
    }

    public void setAnimationStartTick(int tick) {
        this.f_19804_.m_135381_(TEST_TIMER, (Object)tick);
    }

    public int getTickCount() {
        return (Integer)this.f_19804_.m_135370_(TICKCOUNT);
    }

    public void setTickCount(int tick) {
        this.f_19804_.m_135381_(TICKCOUNT, (Object)tick);
    }

    public void m_7895_(int i, boolean b) {
    }

    @NotNull
    public SoundEvent m_7930_() {
        return SoundEvents.f_12308_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setTickCount(this.f_19797_);
        }
        if (this.getTickCount() % 60 == 0) {
            this.setActive(true);
        }
        if (this.isActive() && this.getTickCount() % 60 >= 8) {
            this.setActive(false);
            this.visibleEntities.clear();
        }
        if (!this.m_6084_()) {
            this.setActive(false);
        }
        if (this.isActive()) {
            this.searchAndAttack();
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            BrokenDinamoEntity dinamo = (BrokenDinamoEntity)((EntityType)CompanionsEntities.BROKEN_DINAMO.get()).m_20615_(this.m_9236_());
            if (dinamo != null && this.m_9236_().f_46441_.m_188501_() < 0.15f && !this.m_9236_().f_46443_) {
                dinamo.m_20219_(this.m_20182_());
                dinamo.setLifetime(new Random().nextInt(6000, 10000));
                this.m_9236_().m_7967_((Entity)dinamo);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void searchAndAttack() {
        this.visibleEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(10.0), entity -> {
            if (entity instanceof Monster) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity instanceof LivingEntity;
        }).stream().filter(arg_0 -> ((IllagerGolemEntity)this).m_142582_(arg_0)).collect(Collectors.toList());
        if (!this.visibleEntities.isEmpty()) {
            if (this.m_9236_().m_5776_()) {
                double radius = 0.42;
                for (int i = 0; i < 360; i += 120) {
                    double rad = Math.toRadians(i);
                    double particleX = this.m_20182_().f_82479_ + radius * Math.cos(rad);
                    double particleZ = this.m_20182_().f_82481_ + radius * Math.sin(rad);
                    this.m_9236_().m_7106_((ParticleOptions)CompanionsParticles.ILLAGER_GOLEM_SPARK.get(), particleX, this.m_20182_().m_7098_() + (double)this.m_20206_() - 0.6, particleZ, 0.0, 0.35, 0.0);
                }
            }
            int elapsed = this.getTickCount() - this.getAnimationStartTick();
            if (!this.m_9236_().f_46443_ && elapsed >= 3 && elapsed < 8) {
                for (Entity entity2 : this.visibleEntities) {
                    LivingEntity e;
                    if (!(entity2 instanceof LivingEntity) || Util.areEntitiesLinked((Entity)this, (Entity)(e = (LivingEntity)entity2))) continue;
                    this.m_7327_((Entity)e);
                }
            }
        }
    }

    public void setActive(boolean active) {
        if (active && !this.isActive()) {
            this.setAnimationStartTick(this.getTickCount());
        }
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_START_TICK, (Object)0);
        this.f_19804_.m_135372_(TEST_TIMER, (Object)0);
        this.f_19804_.m_135372_(TICKCOUNT, (Object)0);
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        super.m_7355_(pPos, pState);
        this.m_5496_(CompanionsSounds.DINAMO_STEP.get(), 0.07875f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.DINAMO_IDLE.get();
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        this.m_5496_(CompanionsSounds.DINAMO_HURT.get(), 0.25f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.DINAMO_DEATH.get();
    }

    public int m_8100_() {
        return 320;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isActive() && !this.visibleEntities.isEmpty()) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(this.SHOOT);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

