/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.registry.KnightLibItems;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BrokenDinamoEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE1 = RawAnimation.begin().thenPlay("broken1");
    private final RawAnimation IDLE2 = RawAnimation.begin().thenPlay("broken2");
    private final RawAnimation FIX1 = RawAnimation.begin().thenPlay("fixing1");
    private final RawAnimation FIX2 = RawAnimation.begin().thenPlay("fixing2");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(BrokenDinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(BrokenDinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(BrokenDinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final int ANIMATION_FIX_TICKS = 40;
    private int animationCounter = -1;
    private int woodAmount = 10 + this.m_217043_().m_216339_(10, 30);
    private int ironAmount = 10 + this.m_217043_().m_216339_(10, 30);
    private boolean confirmationCheck = false;

    public BrokenDinamoEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public void m_8119_() {
        double prevX = this.m_20185_();
        double prevZ = this.m_20189_();
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if ((this.getState() == 3 || this.getState() == 7) && this.animationCounter == -1) {
                ++this.animationCounter;
            }
            if (this.animationCounter >= 40) {
                if (this.getState() == 3) {
                    this.animationCounter = -1;
                    this.cycleState();
                } else {
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (this.getOwnerUUID() != null) {
                            this.tameDinamo(serverLevel.m_8791_(this.getOwnerUUID()));
                        }
                    }
                    this.m_146870_();
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11736_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.generatePoofParticles();
            }
            if (this.animationCounter != -1) {
                ++this.animationCounter;
            }
            if (this.f_19797_ >= this.getLifetime() && this.getLifetime() != -1) {
                this.generatePoofParticles();
                this.m_146870_();
            }
        }
        this.m_6034_(prevX, this.m_20186_(), prevZ);
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.getState() == 3 || this.getState() == 7) {
            return InteractionResult.PASS;
        }
        if (pPlayer.m_20148_().equals(this.getOwnerUUID()) || this.getOwnerUUID() == null) {
            ItemStack stack = pPlayer.m_21120_(pHand);
            return switch (this.getState()) {
                case 0 -> this.giveFirstItem(pPlayer, pHand, stack);
                case 1 -> this.giveSecondItem(pPlayer, pHand, stack);
                case 4 -> this.giveThirdItem(pPlayer, pHand, stack);
                case 5 -> this.giveFourthItem(pPlayer, pHand, stack);
                default -> this.wrenchInteract(pPlayer, pHand, stack);
            };
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private void tameDinamo(Entity e) {
        if (e instanceof Player) {
            Player player = (Player)e;
            DinamoEntity dinamo = (DinamoEntity)((EntityType)CompanionsEntities.DINAMO.get()).m_20615_(this.m_9236_());
            if (dinamo != null) {
                dinamo.m_20219_(this.m_20182_());
                dinamo.tameInteraction(player);
                this.m_9236_().m_7967_((Entity)dinamo);
            }
        }
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    private void generateWaxParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175829_, this.m_20182_().f_82479_, this.m_20186_() + (double)(this.m_20206_() * 0.5f), this.m_20182_().f_82481_, 8, 0.75, 0.75, 0.75, 0.065);
        }
    }

    private InteractionResult giveFirstItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == Items.f_42647_ && stack.m_41613_() >= this.woodAmount) {
            if (this.confirmationCheck) {
                if (this.m_9236_().f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(this.woodAmount);
                }
                this.cycleState();
                this.confirmationCheck = false;
                if (this.getOwnerUUID() == null) {
                    this.setOwnerUUID(pPlayer.m_20148_());
                }
                pPlayer.m_5661_((Component)Component.m_237110_((String)"broken_dinamo.companions.client_message.wood_consumed", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.woodAmount)).m_130940_(ChatFormatting.ITALIC)}), true);
                pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.generateWaxParticles();
                return InteractionResult.SUCCESS;
            }
        } else {
            pPlayer.m_5661_((Component)Component.m_237110_((String)"broken_dinamo.companions.client_message.requires_wood", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.woodAmount)).m_130940_(ChatFormatting.ITALIC)}), true);
            pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        pPlayer.m_5661_((Component)Component.m_237110_((String)"broken_dinamo.companions.client_message.wood_will_get_consumed", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.woodAmount)).m_130940_(ChatFormatting.ITALIC)}), true);
        this.confirmationCheck = true;
        return InteractionResult.SUCCESS;
    }

    private InteractionResult giveSecondItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == KnightLibItems.HOMUNCULUS.get()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!pPlayer.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.cycleState();
            pPlayer.m_5661_((Component)Component.m_237115_((String)"broken_dinamo.companions.client_message.homunculus_consumed"), true);
            pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.generateWaxParticles();
            return InteractionResult.SUCCESS;
        }
        pPlayer.m_5661_((Component)Component.m_237115_((String)"broken_dinamo.companions.client_message.requires_homunculus"), true);
        pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    private InteractionResult giveThirdItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == Items.f_42416_ && stack.m_41613_() >= this.ironAmount) {
            if (this.confirmationCheck) {
                if (this.m_9236_().f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(this.ironAmount);
                }
                this.cycleState();
                this.confirmationCheck = false;
                if (this.getOwnerUUID() == null) {
                    this.setOwnerUUID(pPlayer.m_20148_());
                }
                pPlayer.m_5661_((Component)Component.m_237110_((String)"broken_dinamo.companions.client_message.iron_consumed", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.ironAmount)).m_130940_(ChatFormatting.ITALIC)}), true);
                pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.generateWaxParticles();
                return InteractionResult.SUCCESS;
            }
        } else {
            pPlayer.m_5661_((Component)Component.m_237110_((String)"broken_dinamo.companions.client_message.requires_iron", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.ironAmount)).m_130940_(ChatFormatting.ITALIC)}), true);
            pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        pPlayer.m_5661_((Component)Component.m_237110_((String)"broken_dinamo.companions.client_message.iron_will_get_consumed", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.ironAmount)).m_130940_(ChatFormatting.ITALIC)}), true);
        pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.confirmationCheck = true;
        return InteractionResult.SUCCESS;
    }

    private InteractionResult giveFourthItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == CompanionsBlocks.TESLA_COIL.get().m_5456_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!pPlayer.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.cycleState();
            pPlayer.m_5661_((Component)Component.m_237115_((String)"broken_dinamo.companions.client_message.tesla_coil_consumed"), true);
            pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.generateWaxParticles();
            return InteractionResult.SUCCESS;
        }
        pPlayer.m_5661_((Component)Component.m_237115_((String)"broken_dinamo.companions.client_message.requires_tesla_coil"), true);
        pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    private InteractionResult wrenchInteract(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == CompanionsItems.WRENCH.get()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!pPlayer.m_150110_().f_35937_) {
                stack.m_41622_(1, (LivingEntity)pPlayer, p -> p.m_21190_(pHand));
            }
            this.cycleState();
            pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        pPlayer.m_5661_((Component)Component.m_237115_((String)"broken_dinamo.companions.client_message.requires_wrench"), true);
        pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return this.getState() != 2 ? super.m_6972_(pPose) : EntityDimensions.m_20395_((float)1.0f, (float)1.0f);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void cycleState() {
        this.f_19804_.m_135381_(STATE, (Object)(this.getState() + 1));
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getLifetime() {
        return (Integer)this.f_19804_.m_135370_(LIFETIME);
    }

    public void setLifetime(int lifetime) {
        this.f_19804_.m_135381_(LIFETIME, (Object)lifetime);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(LIFETIME, (Object)-1);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Lifetime")) {
            this.setLifetime(pCompound.m_128451_("Lifetime"));
        }
        if (pCompound.m_128441_("State")) {
            this.setState(pCompound.m_128451_("State"));
        }
        if (pCompound.m_128441_("WoodAmount")) {
            this.woodAmount = pCompound.m_128451_("WoodAmount");
        }
        if (pCompound.m_128441_("IronAmount")) {
            this.ironAmount = pCompound.m_128451_("IronAmount");
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Lifetime", this.getLifetime());
        pCompound.m_128405_("State", this.getState());
        pCompound.m_128405_("WoodAmount", this.woodAmount);
        pCompound.m_128405_("IronAmount", this.ironAmount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getState() == 7) {
            event.getController().setAnimation(this.FIX2);
        } else if (this.getState() == 4 || this.getState() == 5 || this.getState() == 6) {
            event.getController().setAnimation(this.IDLE2);
        } else if (this.getState() == 3) {
            event.getController().setAnimation(this.FIX1);
        } else if (this.getState() == 0 || this.getState() == 1 || this.getState() == 2) {
            event.getController().setAnimation(this.IDLE1);
        }
        return PlayState.CONTINUE;
    }
}

