/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ShadeMawEntity
extends ShadeEntity
implements PlayerRideableJumping {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation RUN = RawAnimation.begin().thenPlay("run");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation BITE = RawAnimation.begin().thenPlay("bite");
    private final RawAnimation SWIM = RawAnimation.begin().thenPlay("swim");
    private static final int ANIMATION_SPAWN_MAX_TICKS = 130;
    private static final float WALK_THETA = 0.02f;
    private static final float RUN_THETA = 0.375f;
    private static final float ACCEL = 0.02f;
    private static final float LIQUID_DRAG = 0.9f;
    private float throttle = 0.0f;
    private boolean canJump = true;
    private int jumpCharge = 0;
    private boolean hasSpawned = false;

    public ShadeMawEntity(EntityType<? extends CompanionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
        this.m_274367_(1.1f);
        this.m_20011_(this.m_142242_());
    }

    @Override
    public int getMaxLifetime() {
        return CompanionsConfig.SHADOW_MAW_LIFETIME;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    @NotNull
    public AABB m_142242_() {
        float hw = (float)((double)this.m_20205_() * 0.8 / 2.0);
        return new AABB(this.m_20185_() - (double)hw, this.m_20186_(), this.m_20189_() - (double)hw, this.m_20185_() + (double)hw, this.m_20186_() + (double)this.m_20206_(), this.m_20189_() + (double)hw);
    }

    public float m_6143_() {
        return (float)(((double)this.m_20205_() - (double)this.m_20205_() * 0.8) * 0.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 10.0f, 4.0f, false){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !ShadeMawEntity.this.isSpawning();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.SHADOW_MAW_MAX_LIFE).m_22268_(Attributes.f_22281_, CompanionsConfig.SHADOW_MAW_DAMAGE).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.45f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        this.m_216990_(CompanionsSounds.SHADE_HURT.get());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.SHADE_IDLE.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.m_20184_().m_165925_() > 0.140625) {
            if (this.f_19797_ % 5 == 0) {
                this.m_5496_(CompanionsSounds.SHADE_STEP.get(), 2.0f, 1.0f);
            }
        } else {
            this.m_5496_(CompanionsSounds.SHADE_STEP.get(), 2.0f, 1.0f);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20301_(this.m_6062_());
        if (this.m_9236_().f_46443_) {
            Companions.PROXY.tickShadeMaw(this);
        }
        if (!this.hasSpawned && this.isSpawning()) {
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setIsSpawning(false), (int)130);
            TickScheduler.scheduleBoth((Level)this.m_9236_(), () -> ((ShadeMawEntity)this).m_6210_(), (int)110);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.m_6842_(false), (int)5);
            this.hasSpawned = true;
        }
        if (this.f_19797_ % 6 == 0 && !this.isSpawning()) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            double dy = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            double dz = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
            }
        }
        this.setLifetime(this.getLifetime() - 1);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_21525_() && (entity = this.m_146895_()) instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            return e;
        }
        return null;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_7337_(@NotNull Entity pEntity) {
        if (pEntity == this.m_146895_()) {
            return false;
        }
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            return player.equals((Object)this.m_269323_());
        }
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_7023_(@NotNull Vec3 travelVec) {
        LivingEntity rider = this.m_6688_();
        if (rider == null && !this.m_9236_().m_6425_(this.m_20183_()).m_76178_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.8));
            this.m_20282_(true);
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        if (this.m_20160_() && rider != null && !this.isSpawning()) {
            this.m_146922_(rider.m_146908_());
            this.f_20883_ = this.f_19859_ = this.m_146908_();
            float strafe = rider.f_20900_ * 0.5f;
            float forward = rider.f_20902_;
            if (forward < 0.0f) {
                forward *= 0.25f;
            }
            this.throttle = Math.abs(forward) > 0.001f || Math.abs(strafe) > 0.001f ? Mth.m_14036_((float)(this.throttle + 0.02f), (float)0.0f, (float)1.0f) : Mth.m_14036_((float)(this.throttle - 0.03f), (float)0.0f, (float)1.0f);
            if (this.f_19862_ && !this.isInFluidType()) {
                this.throttle = 0.3525f;
                this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            }
            if (this.isInFluidType()) {
                double len;
                float speed = (float)this.m_21133_(Attributes.f_22279_) * (0.6f + 0.2f * this.throttle);
                Vec3 lookDir = rider.m_20154_().m_82541_();
                Vec3 motion = lookDir.m_82490_((double)(speed * forward));
                if (Math.abs(strafe) > 0.001f) {
                    motion = motion.m_82549_(new Vec3(0.0, 1.0, 0.0).m_82537_(lookDir).m_82541_().m_82490_((double)(speed * strafe)));
                }
                if (this.isOnLiquidSurface() && forward > 0.05f) {
                    Vec3 fHoriz = new Vec3(lookDir.f_82479_, 0.0, lookDir.f_82481_).m_82541_();
                    BlockPos inFront = BlockPos.m_274561_((double)(this.m_20185_() + fHoriz.f_82479_ * 0.8), (double)(this.m_20186_() + 0.2), (double)(this.m_20189_() + fHoriz.f_82481_ * 0.8));
                    motion = this.m_9236_().m_6425_(inFront).m_76178_() ? motion.m_82520_(0.0, 0.26, 0.0).m_82549_(fHoriz.m_82490_(0.05)) : motion.m_82520_(0.0, 0.03, 0.0);
                }
                if (this.f_19862_) {
                    double upAmount = this.isOnLiquidSurface() ? Math.max(0.22, (double)speed * 0.35) : Math.max(0.12, (double)speed * 0.25);
                    Vec3 right = new Vec3(0.0, 1.0, 0.0).m_82537_(lookDir).m_82541_();
                    motion = motion.m_82520_(0.0, upAmount, 0.0).m_82549_(right.m_82490_((double)(speed * 0.2f * (float)(strafe >= 0.0f ? 1 : -1))));
                }
                if ((len = motion.m_82553_()) > 0.9) {
                    motion = motion.m_82490_(0.9 / len);
                }
                this.m_146926_((float)(-Math.toDegrees(Math.atan2(motion.f_82480_, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)))));
                this.m_6478_(MoverType.SELF, motion);
                this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
                this.m_20282_(true);
            } else {
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * this.throttle);
                super.m_7023_(new Vec3((double)strafe, travelVec.f_82480_, (double)Math.signum(forward)));
            }
            return;
        }
        super.m_7023_(travelVec);
    }

    protected void m_274498_(@NotNull Player rider, @NotNull Vec3 travelVector) {
        super.m_274498_(rider, travelVector);
        if (rider.m_21124_(MobEffects.f_19607_) == null) {
            rider.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 10, 0, false, false));
        }
        if (this.isInAnyFluid()) {
            rider.m_20124_(Pose.SWIMMING);
        }
        if (rider.m_20069_()) {
            rider.m_20301_(rider.m_6062_());
        }
        if (rider.m_20077_()) {
            rider.m_252836_();
            rider.m_20095_();
        }
        if (!this.m_9236_().f_46443_ && rider.f_20911_ && rider.m_21205_().m_41619_()) {
            this.doAttack();
            rider.f_20911_ = false;
        }
        if (this.jumpCharge > 0 && this.canJump && this.m_20096_()) {
            double yStr;
            if (this.isOnLiquidSurface()) {
                yStr = 0.5;
            } else if (this.m_20096_()) {
                yStr = 0.25 + 0.008 * (double)this.jumpCharge;
            } else {
                return;
            }
            this.m_20334_(this.m_20184_().f_82479_, yStr, this.m_20184_().f_82481_);
            this.f_19812_ = true;
            this.jumpCharge = 0;
        }
    }

    private void doAttack() {
        if (this.getAttackType() != 1) {
            this.setAttackType(1);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setAttackType(0), (int)12);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> {
                for (Entity e : this.m_9236_().m_45976_(Entity.class, new AABB(this.m_20183_()).m_82400_(3.0))) {
                    LivingEntity livingEntity;
                    if (!(e instanceof LivingEntity) || !this.m_142582_((Entity)(livingEntity = (LivingEntity)e)) || !ShadeMawEntity.isEntityInFront((LivingEntity)this, (Entity)livingEntity, 150.0) || livingEntity == this) continue;
                    this.m_7327_((Entity)livingEntity);
                    livingEntity.m_147240_(0.5, this.m_20185_() - livingEntity.m_20185_(), this.m_20189_() - livingEntity.m_20189_());
                }
            }, (int)10);
            this.m_5496_(CompanionsSounds.SHADE_MAW_BITE.get(), 0.3325f, 1.0f);
        }
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget;
        Vec3 view = viewer.m_20154_().m_82541_();
        double angle = Math.acos(view.m_82526_(toTarget = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0).m_82546_(viewer.m_20299_(1.0f)).m_82541_())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (!player.m_36341_() && !player.m_6144_() && this.m_269323_() != null && player.equals((Object)this.m_269323_())) {
            if (!this.m_9236_().f_46443_ && !this.isSpawning()) {
                player.m_7998_((Entity)this, true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_19956_(@NotNull Entity pPassenger, @NotNull Entity.MoveFunction pCallback) {
        if (this.m_20363_(pPassenger)) {
            double baseY = this.m_20186_() + this.m_6048_() + pPassenger.m_6049_();
            if (this.isInAnyFluid()) {
                baseY -= 1.35;
            }
            pCallback.m_20372_(pPassenger, this.m_20185_(), baseY + 0.5, this.m_20189_());
        }
    }

    public void m_7888_(int strength) {
        if (strength > 0) {
            this.jumpCharge = Mth.m_14045_((int)strength, (int)0, (int)100);
            if (this.isOnLiquidSurface()) {
                this.m_20334_(this.m_20184_().f_82479_, 0.5, this.m_20184_().f_82481_);
                this.f_19812_ = true;
                this.jumpCharge = 0;
            }
        }
    }

    private boolean isOnLiquidSurface() {
        if (!this.isInAnyFluid()) {
            return false;
        }
        BlockPos pos = this.m_20183_();
        BlockPos abovePos = pos.m_7494_();
        FluidState fluidState = this.m_9236_().m_6425_(pos);
        FluidState aboveFluidState = this.m_9236_().m_6425_(abovePos);
        return !fluidState.m_76178_() && aboveFluidState.m_76178_();
    }

    public boolean m_7132_() {
        return this.canJump && (this.m_20096_() || this.isOnLiquidSurface());
    }

    public void m_7199_(int strength) {
        this.jumpCharge = strength;
        this.canJump = false;
    }

    public void m_8012_() {
        this.canJump = true;
    }

    public int m_245614_() {
        return 0;
    }

    protected boolean m_7310_(@NotNull Entity pPassenger) {
        return super.m_7310_(pPassenger);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, @NotNull BlockState pState, @NotNull BlockPos pPos) {
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
        if (!this.isSpawning()) {
            super.m_147240_(pStrength, pX, pZ);
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 2, this::attackPredicate)});
    }

    public boolean isInAnyFluid() {
        Vec3 eyePos = this.m_20299_(1.0f);
        return !this.m_9236_().m_6425_(new BlockPos((int)eyePos.f_82479_, (int)eyePos.f_82480_, (int)eyePos.f_82481_)).m_76178_();
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        double speed = this.m_20184_().m_165925_();
        if (this.isSpawning()) {
            event.setAnimation(this.SPAWN);
        } else if (this.isInAnyFluid()) {
            event.setAnimation(this.SWIM);
        } else if (speed > 0.140625) {
            event.setAnimation(this.RUN);
        } else if (speed > (double)4.0E-4f) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (this.getAttackType() == 1 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.BITE);
        }
        return PlayState.CONTINUE;
    }
}

