/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.dinamo.DinamoAttackBehaviour;
import dev.xylonity.companions.common.tesla.behaviour.dinamo.DinamoPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaGeneratorBehaviour;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DinamoEntity
extends CompanionEntity
implements GeoEntity {
    private final TeslaConnectionManager connectionManager;
    public List<LivingEntity> entitiesToAttack = new ArrayList<LivingEntity>();
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("roll");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CYCLE_COUNTER = SynchedEntityData.m_135353_(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_START_TICK = SynchedEntityData.m_135353_(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACK_ACTIVE = SynchedEntityData.m_135353_(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_CYCLE_COUNTER = SynchedEntityData.m_135353_(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TARGET_IDS = SynchedEntityData.m_135353_(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SHOULD_ATTACK = SynchedEntityData.m_135353_(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ITeslaGeneratorBehaviour pulseBehavior;
    private final ITeslaGeneratorBehaviour attackBehavior;

    public DinamoEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.connectionManager = TeslaConnectionManager.getInstance();
        this.pulseBehavior = new DinamoPulseBehaviour();
        this.attackBehavior = new DinamoAttackBehaviour();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(2, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this){

            @Override
            public void m_8056_() {
                super.m_8056_();
                DinamoEntity.this.setTargetIds(DinamoEntity.this.getTargetIds() + this.getOwnerLastHurt().m_19879_() + ";");
            }
        });
    }

    public TeslaConnectionManager.ConnectionNode asConnectionNode() {
        return TeslaConnectionManager.ConnectionNode.forEntity(this.m_20148_(), this.m_9236_().m_46472_().m_135782_());
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        ListTag outgoing = new ListTag();
        for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(this.asConnectionNode())) {
            outgoing.add((Object)node.serialize());
        }
        tag.m_128365_("OutgoingConnections", (Tag)outgoing);
        tag.m_128405_("AnimationStartTick", this.getAnimationStartTick());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.DINAMO_KEEP_CHUNK_LOADED;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        TeslaConnectionManager.ConnectionNode me = this.asConnectionNode();
        this.connectionManager.getOutgoing(me).clear();
        this.connectionManager.getIncoming(me).clear();
        if (tag.m_128441_("OutgoingConnections")) {
            ListTag outgoingList = tag.m_128437_("OutgoingConnections", 10);
            for (Tag t : outgoingList) {
                TeslaConnectionManager.ConnectionNode node = TeslaConnectionManager.ConnectionNode.deserialize((CompoundTag)t);
                this.connectionManager.addConnection(me, node, true);
            }
        }
        this.connectionManager.recalculateDistances();
    }

    public void m_6667_(@NotNull DamageSource pCause) {
        super.m_6667_(pCause);
        HashSet<TeslaConnectionManager.ConnectionNode> outNodes = new HashSet<TeslaConnectionManager.ConnectionNode>(this.connectionManager.getOutgoing(this.asConnectionNode()));
        for (TeslaConnectionManager.ConnectionNode target : outNodes) {
            this.connectionManager.removeConnection(this.asConnectionNode(), target);
        }
        HashSet<TeslaConnectionManager.ConnectionNode> inNodes = new HashSet<TeslaConnectionManager.ConnectionNode>(this.connectionManager.getIncoming(this.asConnectionNode()));
        for (TeslaConnectionManager.ConnectionNode source : inNodes) {
            this.connectionManager.removeConnection(source, this.asConnectionNode());
        }
        this.connectionManager.removeConnectionNode(this.asConnectionNode());
        this.connectionManager.recalculateDistances();
    }

    public static AttributeSupplier setAttributes() {
        return Raider.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.DINAMO_MAX_LIFE).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_21824_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && this.m_269323_() == player && player.m_21205_().m_41720_() != CompanionsItems.WRENCH.get()) {
            if (player.m_6144_() && this.getMainAction() != 0) {
                this.setShouldAttack(!this.shouldAttack());
                if (this.shouldAttack()) {
                    player.m_5661_((Component)Component.m_237115_((String)"dinamo.companions.client_message.attack").m_130940_(ChatFormatting.GREEN), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"dinamo.companions.client_message.no_attack").m_130940_(ChatFormatting.GREEN), true);
                }
            } else {
                if (this.m_9236_().f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                this.handleDefaultMainActionAndHeal(player, hand);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            this.setActive(false);
        }
        if (this.m_9236_().f_46443_ && this.getAttackCycleCounter() >= 60) {
            this.entitiesToAttack.clear();
        }
        if (this.getMainAction() == 0) {
            this.pulseBehavior.tick(this);
        } else {
            this.attackBehavior.tick(this);
        }
        if (this.m_9236_().f_46443_ && !this.getTargetIds().isEmpty() && !this.getTargetIds().isBlank()) {
            for (String s : this.getTargetIds().split(";")) {
                Entity entity = this.m_9236_().m_6815_(Integer.parseInt(s));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity e = (LivingEntity)entity;
                this.entitiesToAttack.add(e);
            }
        }
    }

    @Override
    public boolean m_21532_() {
        return true;
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public String getTargetIds() {
        return (String)this.f_19804_.m_135370_(TARGET_IDS);
    }

    public void setTargetIds(String uuid) {
        this.f_19804_.m_135381_(TARGET_IDS, (Object)uuid);
    }

    public boolean isActiveForAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK_ACTIVE);
    }

    public void setActiveForAttack(boolean active) {
        this.f_19804_.m_135381_(ATTACK_ACTIVE, (Object)active);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public int getAnimationStartTick() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_START_TICK);
    }

    public void setAnimationStartTick(int tick) {
        this.f_19804_.m_135381_(ANIMATION_START_TICK, (Object)tick);
    }

    public int getCycleCounter() {
        return (Integer)this.f_19804_.m_135370_(CYCLE_COUNTER);
    }

    public void setCycleCounter(int tick) {
        this.f_19804_.m_135381_(CYCLE_COUNTER, (Object)tick);
    }

    public int getAttackCycleCounter() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_CYCLE_COUNTER);
    }

    public void setAttackCycleCounter(int tick) {
        this.f_19804_.m_135381_(ATTACK_CYCLE_COUNTER, (Object)tick);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public boolean shouldAttack() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_ATTACK);
    }

    public void setShouldAttack(boolean shouldAttack) {
        this.f_19804_.m_135381_(SHOULD_ATTACK, (Object)shouldAttack);
    }

    public void handleNodeSelection(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect) {
        this.connectionManager.addConnection(thisNode, nodeToConnect);
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        super.m_7355_(pPos, pState);
        this.m_5496_(CompanionsSounds.DINAMO_STEP.get(), 0.07875f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.DINAMO_IDLE.get();
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        this.m_5496_(CompanionsSounds.DINAMO_HURT.get(), 0.25f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.DINAMO_DEATH.get();
    }

    public int m_8100_() {
        return 400;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(CYCLE_COUNTER, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_START_TICK, (Object)0);
        this.f_19804_.m_135372_(ATTACK_ACTIVE, (Object)true);
        this.f_19804_.m_135372_(ATTACK_CYCLE_COUNTER, (Object)0);
        this.f_19804_.m_135372_(SHOULD_ATTACK, (Object)true);
        this.f_19804_.m_135372_(TARGET_IDS, (Object)"");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

