/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionAdultAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionAdultFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionBaseAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionBaseLongAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionPupaApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionPupaAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionSoldierAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionSoldierLongAttackGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class AntlionEntity
extends CompanionEntity
implements PlayerRideable {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation SIT2 = RawAnimation.begin().thenPlay("sit2");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private final RawAnimation DIG_IN = RawAnimation.begin().thenPlay("dig");
    private final RawAnimation DIG_OUT = RawAnimation.begin().thenPlay("dig_out");
    private final RawAnimation DIG_IDLE = RawAnimation.begin().thenPlay("dig_idle");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation TURN = RawAnimation.begin().thenPlay("turn");
    private final RawAnimation UNSTUCK = RawAnimation.begin().thenPlay("unstuck");
    private final RawAnimation FALL_IDLE = RawAnimation.begin().thenPlay("fall_idle");
    private final RawAnimation HIT_GROUND = RawAnimation.begin().thenPlay("hit_ground");
    private final RawAnimation DIG_ATTACK = RawAnimation.begin().thenPlay("dig_attack");
    private final RawAnimation DIG_SHOOT = RawAnimation.begin().thenPlay("dig_attack2");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_FUR = SynchedEntityData.m_135353_(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.m_135353_(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int ANIMATION_BASE_DIG_IN_TICKS = 55;
    private static final int ANIMATION_BASE_DIG_OUT_TICKS = 15;
    private static final int ANIMATION_ADULT_HIT_GROUND_TICKS = 7;
    private static final int ANIMATION_ADULT_UNSTUCK_TICKS = 35;
    private static final int ANIMATION_ADULT_TURN_TICKS = 10;
    private static final int MAX_FALL_TICKS = 8;
    private static final int NO_TARGET_MAX_TICKS = 20;
    private static final float MIN_SPEED_FOR_DESCENT = 0.3f;
    private static final float MAX_SPEED_FOR_DESCENT = 1.01f;
    private Vec3 vel = Vec3.f_82478_;
    private int diginCounter = -1;
    private int digoutCounter = -1;
    private int noTargetCounter = -1;
    private int hitGroundCounter = -1;
    private int unstuckCounter = -1;
    private int turnCounter = -1;
    private int fallCounter = -1;
    private float throttle = 0.0f;
    private boolean wasNight = this.m_9236_().m_46462_();

    public AntlionEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(this.getVariant() == 2);
        if (!this.m_9236_().f_46443_) {
            if (this.getVariant() == 0) {
                this.setNoMovement(this.isUnderground() || this.getState() == 1);
                if (this.getState() == 1 && this.diginCounter == -1) {
                    ++this.diginCounter;
                }
                if (this.getState() == 2 && this.noTargetCounter == -1 && this.m_5448_() == null) {
                    ++this.noTargetCounter;
                } else if (this.getState() == 2 && this.noTargetCounter == -1 && this.m_5448_() == null) {
                    this.noTargetCounter = -1;
                }
                if (this.diginCounter != -1) {
                    ++this.diginCounter;
                }
                if (this.digoutCounter != -1) {
                    ++this.digoutCounter;
                }
                if (this.noTargetCounter != -1) {
                    ++this.noTargetCounter;
                }
                if (this.diginCounter == 55) {
                    this.cycleState();
                    this.diginCounter = -1;
                }
                if (this.noTargetCounter == 20) {
                    this.cycleState();
                    this.noTargetCounter = -1;
                    ++this.digoutCounter;
                }
                if (this.digoutCounter == 15) {
                    this.cycleState();
                    this.digoutCounter = -1;
                }
                if (this.diginCounter == 20 || this.diginCounter == 35 || this.digoutCounter == 5) {
                    this.earthquake();
                }
            } else if (this.getVariant() == 2) {
                if (this.f_19797_ % 30 == 0 && this.getMainAction() != 0) {
                    this.m_216990_(CompanionsSounds.ADULT_ANTLION_FLY.get());
                }
                this.setNoMovement(this.getState() != 0);
                if (this.getState() == 1 && this.turnCounter == -1) {
                    this.turnCounter = 0;
                }
                if (this.getState() == 2 && this.fallCounter == -1) {
                    this.fallCounter = 0;
                }
                if (this.getState() == 3 && this.hitGroundCounter == -1) {
                    this.hitGroundCounter = 0;
                }
                if (this.getState() == 4 && this.unstuckCounter == -1) {
                    this.unstuckCounter = 0;
                }
                if (this.hitGroundCounter != -1) {
                    ++this.hitGroundCounter;
                }
                if (this.fallCounter != -1) {
                    ++this.fallCounter;
                }
                if (this.unstuckCounter != -1) {
                    ++this.unstuckCounter;
                }
                if (this.turnCounter != -1) {
                    ++this.turnCounter;
                }
                if (this.fallCounter >= 8) {
                    this.cycleState();
                    this.fallCounter = -1;
                }
                if (this.hitGroundCounter >= 7) {
                    this.cycleState();
                    this.hitGroundCounter = -1;
                }
                if (this.unstuckCounter >= 35) {
                    this.cycleState();
                    this.unstuckCounter = -1;
                }
                if (this.turnCounter >= 10) {
                    this.cycleState();
                    this.turnCounter = -1;
                }
            }
            boolean nowNight = this.m_9236_().m_46462_();
            if (this.wasNight && !nowNight) {
                if (!this.isPhaseLocked()) {
                    this.cycleVariant();
                }
                this.setHasFur(true);
                this.setState(0);
            }
            this.wasNight = nowNight;
        }
    }

    public void m_21839_(boolean pOrderedToSit) {
        BlockPos groundPos;
        super.m_21839_(pOrderedToSit);
        if (!this.m_9236_().f_46443_ && pOrderedToSit && this.getVariant() == 2 && (groundPos = Util.findClosestGroundBelow(this, 7.0f)) != null) {
            double y = (double)groundPos.m_123342_() + 1.0;
            this.m_6021_(this.m_20185_(), y, this.m_20189_());
        }
    }

    private void earthquake() {
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist < 1 || dist > radius) continue;
                BlockPos blockPos = this.m_20183_().m_7918_(x, -1, z);
                BlockState state = this.m_9236_().m_8055_(blockPos);
                if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_) continue;
                if (dist == 1) {
                    this.spawnFallingBlock(blockPos, state, 0.18);
                    continue;
                }
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.spawnFallingBlock(blockPos, state, 0.2), (int)5);
            }
        }
    }

    private void spawnFallingBlock(BlockPos pos, BlockState state, double yDelay) {
        FallingBlockEntity block = new FallingBlockEntity(this.m_9236_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, state);
        block.m_20334_(0.0, yDelay, 0.0);
        this.m_9236_().m_7967_((Entity)block);
        this.m_9236_().m_7471_(pos, false);
    }

    public void cycleState() {
        if (this.getVariant() == 0) {
            switch (this.getState()) {
                case 0: {
                    this.setState(1);
                    break;
                }
                case 1: {
                    this.setState(2);
                    break;
                }
                case 2: {
                    this.setState(3);
                    break;
                }
                case 3: {
                    this.setState(0);
                }
            }
        } else if (this.getVariant() == 2) {
            switch (this.getState()) {
                case 0: {
                    this.setState(1);
                    break;
                }
                case 1: {
                    this.setState(2);
                    break;
                }
                case 2: {
                    this.setState(3);
                    break;
                }
                case 3: {
                    this.setState(4);
                    break;
                }
                case 4: {
                    this.setState(0);
                }
            }
        }
    }

    public void cycleVariant() {
        switch (this.getVariant()) {
            case 0: {
                this.setVariant(1);
                break;
            }
            case 1: {
                this.setVariant(2);
                break;
            }
            case 2: {
                this.setVariant(3);
                break;
            }
            case 3: {
                this.setVariant(0);
            }
        }
        this.spawnVariantParticles();
        this.updateStats();
        this.m_216990_(CompanionsSounds.SPELL_RELEASE_SPEARS.get());
        if (this.getVariant() == 2) {
            this.m_216990_(CompanionsSounds.ADULT_ANTLION_FLY.get());
        }
    }

    private void updateStats() {
        AttributeInstance damage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            double prevHealth = (double)this.m_21233_() * 0.95;
            switch (this.getVariant()) {
                case 0: {
                    maxHealth.m_22100_(CompanionsConfig.ANTLION_NORMAL_MAX_LIFE);
                    if (!((double)this.m_21223_() >= prevHealth)) break;
                    this.m_21153_((float)CompanionsConfig.ANTLION_NORMAL_MAX_LIFE);
                    break;
                }
                case 1: {
                    maxHealth.m_22100_(CompanionsConfig.ANTLION_TANK_MAX_LIFE);
                    if (!((double)this.m_21223_() >= prevHealth)) break;
                    this.m_21153_((float)CompanionsConfig.ANTLION_TANK_MAX_LIFE);
                    break;
                }
                case 2: {
                    maxHealth.m_22100_(CompanionsConfig.ANTLION_FLYER_MAX_LIFE);
                    if (!((double)this.m_21223_() >= prevHealth)) break;
                    this.m_21153_((float)CompanionsConfig.ANTLION_FLYER_MAX_LIFE);
                    break;
                }
                default: {
                    maxHealth.m_22100_(CompanionsConfig.ANTLION_SOLDIER_MAX_LIFE);
                    if (!((double)this.m_21223_() >= prevHealth)) break;
                    this.m_21153_((float)CompanionsConfig.ANTLION_SOLDIER_MAX_LIFE);
                }
            }
        }
        if ((damage = this.m_21051_(Attributes.f_22281_)) != null) {
            switch (this.getVariant()) {
                case 0: {
                    damage.m_22100_(CompanionsConfig.ANTLION_NORMAL_DAMAGE);
                    break;
                }
                case 1: {
                    damage.m_22100_(CompanionsConfig.ANTLION_TANK_DAMAGE);
                    break;
                }
                case 2: {
                    damage.m_22100_(CompanionsConfig.ANTLION_FLYER_DAMAGE);
                    break;
                }
                default: {
                    damage.m_22100_(CompanionsConfig.ANTLION_SOLDIER_DAMAGE);
                }
            }
        }
    }

    private void spawnVariantParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.75;
            double dy = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.75;
            double dz = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.75;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)(this.m_20206_() * 0.5f), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public boolean isUnderground() {
        return this.getVariant() == 0 && this.getState() == 2;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new AntlionBaseAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(2, (Goal)new AntlionBaseLongAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(2, (Goal)new AntlionPupaAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(3, (Goal)new AntlionPupaApproachTargetGoal(this, 0.475, 0.4f, 1.25f));
        this.f_21345_.m_25352_(2, (Goal)new AntlionAdultAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(2, (Goal)new AntlionSoldierAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(2, (Goal)new AntlionSoldierLongAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(4, (Goal)new AntlionAdultFollowOwnerGoal(this, 0.6, 3.0, 7.0, 0.18f));
        this.f_21345_.m_25352_(4, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && AntlionEntity.this.getVariant() != 2;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.f_21345_.m_25352_(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    public static AttributeSupplier setAttributes() {
        return CompanionEntity.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public boolean isPhaseLocked() {
        return (Boolean)this.f_19804_.m_135370_(IS_LOCKED);
    }

    public void setIsPhaseLocked(boolean phase) {
        this.f_19804_.m_135381_(IS_LOCKED, (Object)phase);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean hasFur() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FUR);
    }

    public void setHasFur(boolean hasFur) {
        this.f_19804_.m_135381_(HAS_FUR, (Object)hasFur);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return this.getVariant() != 2 && super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(IS_LOCKED, (Object)false);
        this.f_19804_.m_135372_(HAS_FUR, (Object)true);
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        super.m_6478_(pType, pPos);
        this.m_20101_();
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_() && player == this.m_269323_() && item == CompanionsItems.NETHERITE_CHAINS.get() && !this.isPhaseLocked()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            for (int i = 0; i < 20; ++i) {
                double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                if (level2.f_46441_.m_188501_() < 0.65f) {
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
                }
                if (!(level2.f_46441_.m_188501_() < 0.25f)) continue;
                level2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.2);
            }
            this.m_216990_(CompanionsSounds.SPELL_RELEASE_MARK.get());
            this.setIsPhaseLocked(true);
            return InteractionResult.SUCCESS;
        }
        if (item == Items.f_42574_ && this.m_21824_() && this.m_269323_() != null && this.m_269323_() == player && this.getVariant() == 0 && this.hasFur()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.setHasFur(false);
            AntlionEntity.popResource(this.m_9236_(), this.m_20183_(), new ItemStack((ItemLike)CompanionsItems.ANTLION_FUR.get(), this.m_9236_().f_46441_.m_216339_(1, 4)));
            itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, this.m_5720_(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (item == CompanionsItems.HOURGLASS.get() && this.m_21824_() && this.m_269323_() != null && this.m_269323_() == player && !this.isPhaseLocked()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            this.cycleVariant();
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player == this.m_269323_() && this.getVariant() == 2) {
            if (player.m_6144_()) {
                if (this.handleDefaultMainActionAndHeal(player, hand)) {
                    return InteractionResult.SUCCESS;
                }
            } else if (this.getMainAction() != 0) {
                player.m_7998_((Entity)this, true);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsPhaseLocked(pCompound.m_128471_("IsVariantLocked"));
        if (pCompound.m_128441_("Variant")) {
            this.setVariant(pCompound.m_128451_("Variant"));
        }
        if (pCompound.m_128441_("HasFur")) {
            this.setHasFur(pCompound.m_128471_("HasFur"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getVariant());
        pCompound.m_128379_("HasFur", this.hasFur());
        pCompound.m_128379_("IsVariantLocked", this.isPhaseLocked());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.ANTLION_KEEP_CHUNK_LOADED;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_21525_() && (entity = this.m_146895_()) instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            return e;
        }
        return null;
    }

    public void m_7023_(@NotNull Vec3 travelVec) {
        LivingEntity rider = this.m_6688_();
        if (rider == null || !this.m_20160_()) {
            super.m_7023_(travelVec);
            return;
        }
        this.m_146922_(rider.m_146908_());
        this.f_20883_ = this.f_19859_ = this.m_146908_();
        this.m_146926_(rider.m_146909_() * 0.5f);
        this.throttle = rider.f_20902_ > 0.05f ? Mth.m_14036_((float)(this.throttle + 0.06f), (float)-1.0f, (float)1.0f) : (rider.f_20902_ < -0.05f ? Mth.m_14036_((float)(this.throttle - 0.06f), (float)-1.0f, (float)1.0f) : Mth.m_14179_((float)0.2f, (float)this.throttle, (float)0.0f));
        float speed = (float)this.m_21133_(Attributes.f_22279_) * 1.1f * this.throttle;
        if (this.m_20096_()) {
            speed *= 0.05f;
        }
        float speedMag = Math.abs(speed);
        Vec3 aim = rider.m_20154_().m_82541_();
        Vec3 desired = new Vec3(aim.f_82479_ * (double)speed, 0.0, aim.f_82481_ * (double)speed);
        double newY = speedMag > 0.3f ? -(0.3225 * Mth.m_14008_((double)((speedMag - 0.3f) / 0.71f), (double)0.0, (double)1.0)) : aim.f_82480_ * (double)speed;
        desired = desired.m_193103_(Direction.Axis.Y, newY);
        this.vel = this.vel.m_165921_(desired, (double)0.2825f);
        if (this.f_19862_) {
            this.vel = new Vec3(0.0, this.vel.f_82480_, 0.0);
            this.throttle = 0.0f;
        }
        this.m_6478_(MoverType.SELF, this.vel);
        this.m_20256_(this.vel);
    }

    private static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = EntityType.f_20461_.m_20679_() / 2.0f;
        double d1 = (double)pPos.m_123341_() + 0.5;
        double d2 = (double)pPos.m_123342_() + 1.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.m_123343_() + 0.5;
        AntlionEntity.popResource(pLevel, () -> new ItemEntity(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.f_46443_ && !pStack.m_41619_()) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
    }

    protected void m_19956_(@NotNull Entity pPassenger, @NotNull Entity.MoveFunction pCallback) {
        if (this.m_20363_(pPassenger)) {
            double baseY = this.m_20186_() + this.m_6048_() + pPassenger.m_6049_();
            pCallback.m_20372_(pPassenger, this.m_20185_(), baseY, this.m_20189_());
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return switch (this.getVariant()) {
            case 0, 1 -> CompanionsSounds.ANTLION_DEATH.get();
            case 2 -> CompanionsSounds.ADULT_ANTLION_DEATH.get();
            default -> CompanionsSounds.SOLDIER_ANTLION_DEATH.get();
        };
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return switch (this.getVariant()) {
            case 0, 1 -> CompanionsSounds.ANTLION_HURT.get();
            case 2 -> CompanionsSounds.ADULT_ANTLION_HURT.get();
            default -> CompanionsSounds.SOLDIER_ANTLION_HURT.get();
        };
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return switch (this.getVariant()) {
            case 0, 1, 2 -> CompanionsSounds.ANTLION_IDLE.get();
            default -> CompanionsSounds.SOLDIER_ANTLION_IDLE.get();
        };
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        switch (this.getVariant()) {
            case 0: {
                this.m_216990_(CompanionsSounds.ANTLION_STEPS.get());
                break;
            }
            case 1: {
                this.m_216990_(CompanionsSounds.PUPA_ANTLION_STEP.get());
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.m_216990_(CompanionsSounds.SOLDIER_ANTLION_STEP.get());
            }
        }
    }

    protected void m_274498_(@NotNull Player rider, @NotNull Vec3 travelVector) {
        super.m_274498_(rider, travelVector);
        if (this.getVariant() != 2) {
            rider.m_8127_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "pupaController", 0, this::pupaPredicate)});
    }

    private <T extends GeoAnimatable> PlayState pupaPredicate(AnimationState<T> event) {
        if (this.getVariant() == 1) {
            if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.ATTACK);
            } else if (event.isMoving()) {
                event.getController().setAnimation(this.WALK);
            } else {
                event.getController().setAnimation(this.IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        switch (this.getVariant()) {
            case 0: {
                if (this.getMainAction() == 0) {
                    event.getController().setAnimation(this.SIT);
                    break;
                }
                if (this.getAttackType() == 1) {
                    event.getController().setAnimation(this.DIG_ATTACK);
                    break;
                }
                if (this.getAttackType() == 2) {
                    event.getController().setAnimation(this.DIG_SHOOT);
                    break;
                }
                if (this.getState() == 1) {
                    event.getController().setAnimation(this.DIG_IN);
                    break;
                }
                if (this.getState() == 2) {
                    event.getController().setAnimation(this.DIG_IDLE);
                    break;
                }
                if (this.getState() == 3) {
                    event.getController().setAnimation(this.DIG_OUT);
                    break;
                }
                if (event.isMoving()) {
                    event.getController().setAnimation(this.WALK);
                    break;
                }
                event.getController().setAnimation(this.IDLE);
                break;
            }
            case 2: {
                if (this.getMainAction() == 0) {
                    event.getController().setAnimation(this.SIT);
                    break;
                }
                if (this.getState() == 1) {
                    event.getController().setAnimation(this.TURN);
                    break;
                }
                if (this.getState() == 2) {
                    event.getController().setAnimation(this.FALL_IDLE);
                    break;
                }
                if (this.getState() == 3) {
                    event.getController().setAnimation(this.HIT_GROUND);
                    break;
                }
                if (this.getState() == 4) {
                    event.getController().setAnimation(this.UNSTUCK);
                    break;
                }
                event.getController().setAnimation(this.FLY);
                break;
            }
            case 3: {
                if (this.getMainAction() == 0) {
                    event.getController().setAnimation(this.getSitVariation() == 0 ? this.SIT : this.SIT2);
                    break;
                }
                if (this.getAttackType() == 1) {
                    event.getController().setAnimation(this.ATTACK);
                    break;
                }
                if (this.getAttackType() == 2) {
                    event.getController().setAnimation(this.SHOOT);
                    break;
                }
                if (event.isMoving()) {
                    event.getController().setAnimation(this.WALK);
                    break;
                }
                event.getController().setAnimation(this.IDLE);
            }
        }
        return PlayState.CONTINUE;
    }
}

