/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class MutatedTeddyRandomStrollGoal
extends Goal {
    protected final TeddyEntity teddy;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;
    private final float lerpFactor;
    private Vec3 targetPos;

    public MutatedTeddyRandomStrollGoal(TeddyEntity teddy, double speedModifier, int interval, boolean checkNoActionTime, float lerpFactor) {
        this.teddy = teddy;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.checkNoActionTime = checkNoActionTime;
        this.lerpFactor = lerpFactor;
        this.forceTrigger = false;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public MutatedTeddyRandomStrollGoal(TeddyEntity teddy, double speedModifier) {
        this(teddy, speedModifier, 120, false, 0.1f);
    }

    public boolean m_8036_() {
        Vec3 pos;
        if (this.teddy.getMainAction() != 2 || this.teddy.getPhase() != 2) {
            return false;
        }
        if (this.teddy.m_20160_()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.teddy.m_21216_() >= 100) {
                return false;
            }
            if (this.teddy.m_217043_().m_188503_(MutatedTeddyRandomStrollGoal.m_186073_((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((pos = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = pos.f_82479_;
        this.wantedY = pos.f_82480_;
        this.wantedZ = pos.f_82481_;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 raw = DefaultRandomPos.m_148403_((PathfinderMob)this.teddy, (int)5, (int)1);
        if (raw == null) {
            return null;
        }
        BlockPos topP = this.teddy.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos((int)raw.f_82479_, (int)raw.f_82480_, (int)raw.f_82481_));
        return new Vec3(raw.f_82479_, (double)topP.m_123342_() + 1.0 + this.teddy.m_217043_().m_188500_() * 2.0, raw.f_82481_);
    }

    public void m_8056_() {
        this.targetPos = new Vec3(this.wantedX, this.wantedY, this.wantedZ);
        this.teddy.f_19794_ = true;
    }

    public boolean m_8045_() {
        double dz;
        double dy;
        if (this.teddy.getMainAction() != 2 || this.teddy.getPhase() != 2) {
            return false;
        }
        if (this.teddy.m_20160_() || this.targetPos == null) {
            return false;
        }
        double dx = this.targetPos.f_82479_ - this.teddy.m_20185_();
        return dx * dx + (dy = this.targetPos.f_82480_ - this.teddy.m_20186_()) * dy + (dz = this.targetPos.f_82481_ - this.teddy.m_20189_()) * dz > 1.0;
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            return;
        }
        this.teddy.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPos);
        Vec3 delta = this.targetPos.m_82546_(this.teddy.m_20182_());
        Vec3 dir = delta.m_82490_(1.0 / delta.m_82553_());
        Vec3 vel = dir.m_82490_(this.speedModifier);
        Vec3 cur = this.teddy.m_20184_();
        double vx = Mth.m_14139_((double)this.lerpFactor, (double)cur.f_82479_, (double)vel.f_82479_);
        double vy = Mth.m_14139_((double)this.lerpFactor, (double)cur.f_82480_, (double)vel.f_82480_);
        double vz = Mth.m_14139_((double)this.lerpFactor, (double)cur.f_82481_, (double)vel.f_82481_);
        this.teddy.m_20334_(vx, vy, vz);
    }

    public void m_8041_() {
        this.teddy.f_19794_ = false;
        this.targetPos = null;
    }

    public void trigger() {
        this.forceTrigger = true;
    }
}

